/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.reload;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.reload.compiler.AppClassLoader;
import org.glassfish.jersey.examples.reload.compiler.Compiler;
import org.glassfish.jersey.examples.reload.compiler.JavaFile;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public class App {
    private static final Logger LOGGER = Logger.getLogger(App.class.getName());
    private static final URI BASE_URI = URI.create("http://localhost:8080/flights/");
    public static final String ROOT_PATH = "arrivals";
    public static final String CONFIG_FILENAME = "resources";
    public static final String SRC_MAIN_JAVA = "src/main/java";
    static Container container;

    private static ResourceConfig createResourceConfig(File configFile) {
        ResourceConfig rc = new ResourceConfig();
        try {
            AppClassLoader appClassLoader = new AppClassLoader(Thread.currentThread().getContextClassLoader());
            List<JavaFile> javaFiles = App.getJavaFiles(configFile);
            Compiler.compile(appClassLoader, javaFiles);
            for (JavaFile javaFile : javaFiles) {
                try {
                    rc.registerClasses(new Class[]{appClassLoader.loadClass(javaFile.getClassName())});
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.info(String.format(" ! class %s not found.\n", javaFile.getClassName()));
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rc;
    }

    private static List<JavaFile> getJavaFiles(File configFile) throws Exception {
        LinkedList<JavaFile> javaFiles = new LinkedList<JavaFile>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8"));){
            while (r.ready()) {
                String className = r.readLine();
                if (!className.startsWith("#")) {
                    javaFiles.add(new JavaFile(className, SRC_MAIN_JAVA));
                    LOGGER.info(String.format(" + included class %s.\n", className));
                    continue;
                }
                LOGGER.info(String.format(" - ignored class %s\n", className.substring(1)));
            }
        }
        return javaFiles;
    }

    public static void main(String[] args) throws Exception {
        try {
            LOGGER.info("Resource Config Reload Jersey Example App");
            for (String s : args) {
                if (!s.startsWith("-cp=")) continue;
                Compiler.classpath = s.substring(4);
            }
            ResourceConfig resourceConfig = App.createResourceConfig(new File(CONFIG_FILENAME));
            App.registerReloader(resourceConfig);
            final HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)resourceConfig, (boolean)true);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    server.shutdownNow();
                }
            }));
            server.start();
            System.out.println(String.format("Application started.\nTry out %s%s\nStop the application using CTRL+C", BASE_URI, ROOT_PATH));
            Thread.currentThread().join();
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static Class<?> loadClass(String className) throws Exception {
        JavaFile javaFile = new JavaFile(className, SRC_MAIN_JAVA);
        return Compiler.compile(className, javaFile);
    }

    private static void registerReloader(ResourceConfig resourceConfig) {
        resourceConfig.registerInstances(new Object[]{new ContainerLifecycleListener(){

            public void onStartup(Container container) {
                App.container = container;
                Timer t = new Timer(true);
                t.schedule((TimerTask)new FileCheckTask(), 0L);
            }

            public void onReload(Container container) {
                System.out.println("Application has been reloaded!");
            }

            public void onShutdown(Container container) {
            }
        }});
    }

    static class FileCheckTask
    extends TimerTask {
        FileCheckTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WatchService watcher;
            try {
                watcher = FileSystems.getDefault().newWatchService();
                Path srcDir = Paths.get("src/main/java/org/glassfish/jersey/examples/reload", new String[0]);
                this.registerWatcher(watcher, srcDir);
                Path configFilePath = Paths.get(".", new String[0]);
                this.registerWatcher(watcher, configFilePath);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not initialize watcher service!");
            }
            while (true) {
                try {
                    while (true) {
                        WatchKey watchKey = watcher.take();
                        try {
                            for (WatchEvent watchEvent : watchKey.pollEvents()) {
                                WatchEvent.Kind kind = watchEvent.kind();
                                if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                                WatchEvent pathEvent = watchEvent;
                                Path modifiedFile = (Path)pathEvent.context();
                                System.out.printf("FILE MODIFIED: %s\n", modifiedFile);
                            }
                        }
                        finally {
                            watchKey.reset();
                        }
                        File configFile = new File(App.CONFIG_FILENAME);
                        this.reloadApp(configFile);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        private void registerWatcher(WatchService watcher, Path directory) throws IOException {
            directory.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, FileCheckTask.getWatchEventModifiers());
        }

        private void reloadApp(File configFile) {
            LOGGER.info("Reloading resource classes:");
            ResourceConfig rc = App.createResourceConfig(configFile);
            container.reload(rc);
        }

        private static WatchEvent.Modifier[] getWatchEventModifiers() {
            String className = "com.sun.nio.file.SensitivityWatchEventModifier";
            try {
                Class<?> c = Class.forName(className);
                Field f = c.getField("HIGH");
                WatchEvent.Modifier modifier = (WatchEvent.Modifier)WatchEvent.Modifier.class.cast(f.get(c));
                return new WatchEvent.Modifier[]{modifier};
            }
            catch (Exception e) {
                return new WatchEvent.Modifier[0];
            }
        }
    }
}

