/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.reload.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class JavaFile
extends SimpleJavaFileObject {
    private final String className;
    private final String path;

    public JavaFile(String className, String path) throws Exception {
        super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
        this.className = className;
        this.path = path;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        String filePath = this.path + File.separator + this.className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension;
        byte[] bytes = Files.readAllBytes(Path.of(filePath, new String[0]));
        return new String(bytes);
    }
}

