/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.rx.RxWebTarget;
import org.glassfish.jersey.client.rx.guava.RxListenableFuture;
import org.glassfish.jersey.client.rx.guava.RxListenableFutureInvoker;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.examples.rx.domain.Calculation;
import org.glassfish.jersey.examples.rx.domain.Forecast;
import org.glassfish.jersey.examples.rx.domain.Recommendation;
import org.glassfish.jersey.server.ManagedAsync;
import org.glassfish.jersey.server.Uri;

@Path(value="agent/listenable")
@Produces(value={"application/json"})
public class ListenableFutureAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destination;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculation;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecast;

    @GET
    @ManagedAsync
    public void listenable(@Suspended AsyncResponse async) {
        long time = System.nanoTime();
        AgentResponse response = new AgentResponse();
        ListenableFuture successful = Futures.successfulAsList(Arrays.asList(this.visited(response), this.recommended(response)));
        Futures.addCallback((ListenableFuture)successful, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ListenableFuture<AgentResponse> visited(AgentResponse response) {
        ListenableFuture visited = ((RxListenableFutureInvoker)RxListenableFuture.from((WebTarget)this.destination).path("visited").request().header("Rx-User", (Object)"Guava").rx()).get((GenericType)new /* Unavailable Anonymous Inner Class!! */);
        return Futures.transform((ListenableFuture)visited, destinations -> {
            response.setVisited(destinations);
            return Futures.immediateFuture((Object)response);
        });
    }

    private ListenableFuture<AgentResponse> recommended(AgentResponse response) {
        ListenableFuture destinations = ((RxListenableFutureInvoker)RxListenableFuture.from((WebTarget)this.destination).path("recommended").request().header("Rx-User", (Object)"Guava").rx()).get((GenericType)new /* Unavailable Anonymous Inner Class!! */);
        ListenableFuture recommendations = Futures.transform((ListenableFuture)destinations, destinationList -> {
            ArrayList recommendationList = Lists.newArrayList((Iterable)Lists.transform((List)destinationList, destination -> new Recommendation(destination.getDestination(), null, 0)));
            return Futures.immediateFuture((Object)recommendationList);
        });
        ListenableFuture filledRecommendations = Futures.successfulAsList(Arrays.asList(this.forecasts(recommendations), this.calculations(recommendations)));
        return Futures.transform((ListenableFuture)filledRecommendations, input -> {
            response.setRecommended((List)input.get(0));
            return Futures.immediateFuture((Object)response);
        });
    }

    private ListenableFuture<List<Recommendation>> forecasts(ListenableFuture<List<Recommendation>> recommendations) {
        RxWebTarget rxForecast = RxListenableFuture.from((WebTarget)this.forecast);
        return Futures.transform(recommendations, list -> Futures.successfulAsList((Iterable)Lists.transform((List)list, recommendation -> Futures.transform((ListenableFuture)((RxListenableFutureInvoker)rxForecast.resolveTemplate("destination", (Object)recommendation.getDestination()).request().rx()).get(Forecast.class), forecast -> {
            recommendation.setForecast(forecast.getForecast());
            return Futures.immediateFuture((Object)recommendation);
        }))));
    }

    private ListenableFuture<List<Recommendation>> calculations(ListenableFuture<List<Recommendation>> recommendations) {
        RxWebTarget rxCalculation = RxListenableFuture.from((WebTarget)this.calculation);
        return Futures.transform(recommendations, list -> Futures.successfulAsList((Iterable)Lists.transform((List)list, recommendation -> Futures.transform((ListenableFuture)((RxListenableFutureInvoker)rxCalculation.resolveTemplate("from", (Object)"Moon").resolveTemplate("to", (Object)recommendation.getDestination()).request().rx()).get(Calculation.class), calculation -> {
            recommendation.setPrice(calculation.getPrice());
            return Futures.immediateFuture((Object)recommendation);
        }))));
    }
}

