/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.examples.rx.domain.Calculation;
import org.glassfish.jersey.examples.rx.domain.Destination;
import org.glassfish.jersey.examples.rx.domain.Forecast;
import org.glassfish.jersey.examples.rx.domain.Recommendation;
import org.glassfish.jersey.server.Uri;

@Path(value="agent/sync")
@Produces(value={"application/json"})
public class SyncAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destination;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculation;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecast;

    @GET
    public AgentResponse sync() {
        long time = System.nanoTime();
        AgentResponse response = new AgentResponse();
        ConcurrentLinkedQueue<String> errors = new ConcurrentLinkedQueue<String>();
        try {
            response.setVisited((List)this.destination.path("visited").request().header("Rx-User", (Object)"Sync").get((GenericType)new /* Unavailable Anonymous Inner Class!! */));
        }
        catch (Throwable throwable) {
            errors.offer("Visited: " + throwable.getMessage());
        }
        List recommended = Collections.emptyList();
        try {
            recommended = (List)this.destination.path("recommended").request().header("Rx-User", (Object)"Sync").get((GenericType)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable throwable) {
            errors.offer("Recommended: " + throwable.getMessage());
        }
        HashMap<String, Object> forecasts = new HashMap<String, Object>();
        for (Destination dest : recommended) {
            try {
                forecasts.put(dest.getDestination(), this.forecast.resolveTemplate("destination", (Object)dest.getDestination()).request().get(Forecast.class));
            }
            catch (Throwable throwable) {
                errors.offer("Forecast: " + throwable.getMessage());
            }
        }
        HashMap calculations = new HashMap();
        recommended.stream().forEach(destination -> {
            try {
                calculations.put(destination.getDestination(), this.calculation.resolveTemplate("from", (Object)"Moon").resolveTemplate("to", (Object)destination.getDestination()).request().get(Calculation.class));
            }
            catch (Throwable throwable) {
                errors.offer("Calculation: " + throwable.getMessage());
            }
        });
        ArrayList<Recommendation> recommendations = new ArrayList<Recommendation>(recommended.size());
        for (Destination dest : recommended) {
            Forecast fore = (Forecast)forecasts.get(dest.getDestination());
            Calculation calc = (Calculation)calculations.get(dest.getDestination());
            recommendations.add(new Recommendation(dest.getDestination(), fore != null ? fore.getForecast() : "N/A", calc != null ? calc.getPrice() : -1));
        }
        response.setRecommended(recommendations);
        response.setProcessingTime((System.nanoTime() - time) / 1000000L);
        return response;
    }
}

