/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.examples.rx.domain.Calculation;
import org.glassfish.jersey.examples.rx.domain.Destination;
import org.glassfish.jersey.examples.rx.domain.Forecast;
import org.glassfish.jersey.examples.rx.domain.Recommendation;
import org.glassfish.jersey.server.Uri;

@Path(value="agent/sync")
@Produces(value={"application/json"})
public class SyncAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destination;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculation;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecast;

    @GET
    public AgentResponse sync() {
        long time = System.nanoTime();
        AgentResponse response = new AgentResponse();
        response.setVisited((List)this.destination.path("visited").request().header("Rx-User", (Object)"Sync").get((GenericType)new /* Unavailable Anonymous Inner Class!! */));
        List recommended = (List)this.destination.path("recommended").request().header("Rx-User", (Object)"Sync").get((GenericType)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<Object> forecasts = new ArrayList<Object>(recommended.size());
        for (Object dest : recommended) {
            forecasts.add(this.forecast.resolveTemplate("destination", (Object)dest.getDestination()).request().get(Forecast.class));
        }
        ArrayList<Object> calculations = new ArrayList<Object>(recommended.size());
        for (Destination dest : recommended) {
            calculations.add(this.calculation.resolveTemplate("from", (Object)"Moon").resolveTemplate("to", (Object)dest.getDestination()).request().get(Calculation.class));
        }
        ArrayList<Recommendation> recommendations = new ArrayList<Recommendation>(recommended.size());
        for (int i = 0; i < recommended.size(); ++i) {
            recommendations.add(new Recommendation(((Destination)recommended.get(i)).getDestination(), ((Forecast)forecasts.get(i)).getForecast(), ((Calculation)calculations.get(i)).getPrice()));
        }
        response.setRecommended(recommendations);
        response.setProcessingTime((System.nanoTime() - time) / 1000000L);
        return response;
    }
}

