/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.GenericType;
import jersey.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.examples.rx.domain.Calculation;
import org.glassfish.jersey.examples.rx.domain.Destination;
import org.glassfish.jersey.examples.rx.domain.Forecast;
import org.glassfish.jersey.examples.rx.domain.Recommendation;
import org.glassfish.jersey.server.Uri;

@Path(value="agent/completion")
@Produces(value={"application/json"})
public class CompletionStageAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destinationTarget;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculationTarget;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecastTarget;
    private final ExecutorService executor = new ScheduledThreadPoolExecutor(20, new ThreadFactoryBuilder().setNameFormat("jersey-rx-client-completion-%d").build());

    @GET
    public void completion(@Suspended AsyncResponse async) {
        long time = System.nanoTime();
        ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(new AgentResponse()).thenCombine(this.visited(this.destinationTarget, this.executor, errors), AgentResponse::visited)).thenCombine(this.recommended(this.destinationTarget, this.executor, errors), AgentResponse::recommended)).whenCompleteAsync((response, throwable) -> {
            response.setProcessingTime((System.nanoTime() - time) / 1000000L);
            async.resume(throwable == null ? response : throwable);
        });
    }

    private CompletionStage<List<Destination>> visited(WebTarget destinationTarget, ExecutorService executor, Queue<String> errors) {
        return destinationTarget.path("visited").request().header("Rx-User", (Object)"Java8").rx(executor).get((GenericType)new /* Unavailable Anonymous Inner Class!! */).exceptionally(throwable -> {
            errors.offer("Visited: " + throwable.getMessage());
            return Collections.emptyList();
        });
    }

    private CompletionStage<List<Recommendation>> recommended(WebTarget destinationTarget, ExecutorService executor, Queue<String> errors) {
        CompletionStage<List> recommended = destinationTarget.path("recommended").request().header("Rx-User", (Object)"Java8").rx(executor).get((GenericType)new /* Unavailable Anonymous Inner Class!! */).exceptionally(throwable -> {
            errors.offer("Recommended: " + throwable.getMessage());
            return Collections.emptyList();
        });
        return recommended.thenCompose(destinations -> {
            WebTarget finalForecast = this.forecastTarget;
            WebTarget finalCalculation = this.calculationTarget;
            List recommendations = destinations.stream().map(destination -> {
                CompletionStage<Forecast> forecast = finalForecast.resolveTemplate("destination", (Object)destination.getDestination()).request().rx(executor).get(Forecast.class).exceptionally(throwable -> {
                    errors.offer("Forecast: " + throwable.getMessage());
                    return new Forecast(destination.getDestination(), "N/A");
                });
                CompletionStage<Calculation> calculation = finalCalculation.resolveTemplate("from", (Object)"Moon").resolveTemplate("to", (Object)destination.getDestination()).request().rx(executor).get(Calculation.class).exceptionally(throwable -> {
                    errors.offer("Calculation: " + throwable.getMessage());
                    return new Calculation("Moon", destination.getDestination(), -1);
                });
                return ((CompletableFuture)CompletableFuture.completedFuture(new Recommendation(destination)).thenCombine(forecast, Recommendation::forecast)).thenCombine(calculation, Recommendation::calculation);
            }).collect(Collectors.toList());
            return this.sequence(recommendations);
        });
    }

    private <T> CompletionStage<List<T>> sequence(List<CompletionStage<T>> stages) {
        CompletableFuture<Void> done = CompletableFuture.allOf(stages.toArray(new CompletableFuture[stages.size()]));
        return done.thenApply(v -> stages.stream().map(CompletionStage::toCompletableFuture).map(CompletableFuture::join).collect(Collectors.toList()));
    }
}

