/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.remote;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.jersey.examples.rx.Helper;
import org.glassfish.jersey.examples.rx.domain.Destination;
import org.glassfish.jersey.server.ManagedAsync;

@Singleton
@Path(value="remote/destination")
@Produces(value={"application/json"})
public class DestinationResource {
    private static final Map<String, List<String>> VISITED = new HashMap();

    @GET
    @ManagedAsync
    @Path(value="visited")
    public List<Destination> visited(@HeaderParam(value="Rx-User") @DefaultValue(value="KO") String user) {
        Helper.sleep();
        if (!VISITED.containsKey(user)) {
            VISITED.put(user, Helper.getCountries((int)5));
        }
        return Lists.transform((List)((List)VISITED.get(user)), Destination::new);
    }

    @GET
    @ManagedAsync
    @Path(value="recommended")
    public List<Destination> recommended(@HeaderParam(value="Rx-User") @DefaultValue(value="KO") String user, @QueryParam(value="limit") @DefaultValue(value="5") int limit) {
        Helper.sleep();
        if (!VISITED.containsKey(user)) {
            VISITED.put(user, Helper.getCountries((int)5));
        }
        return Lists.transform((List)Helper.getCountries((int)limit, (List)((List)VISITED.get(user))), Destination::new);
    }

    static {
        VISITED.put("Sync", Helper.getCountries((int)5));
        VISITED.put("Async", Helper.getCountries((int)5));
        VISITED.put("Guava", Helper.getCountries((int)5));
        VISITED.put("RxJava", Helper.getCountries((int)5));
        VISITED.put("RxJava2", Helper.getCountries((int)5));
        VISITED.put("CompletionStage", Helper.getCountries((int)5));
    }
}

