/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.rx.guava.RxListenableFutureInvoker;
import org.glassfish.jersey.client.rx.guava.RxListenableFutureInvokerProvider;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.examples.rx.domain.Calculation;
import org.glassfish.jersey.examples.rx.domain.Forecast;
import org.glassfish.jersey.examples.rx.domain.Recommendation;
import org.glassfish.jersey.server.ManagedAsync;
import org.glassfish.jersey.server.Uri;

@Path(value="agent/listenable")
@Produces(value={"application/json"})
public class ListenableFutureAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destination;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculation;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecast;

    @GET
    @ManagedAsync
    public void listenable(@Suspended AsyncResponse async) {
        long time = System.nanoTime();
        AgentResponse response = new AgentResponse();
        ListenableFuture successful = Futures.successfulAsList(Arrays.asList(this.visited(response), this.recommended(response)));
        Futures.addCallback((ListenableFuture)successful, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)Executors.newSingleThreadExecutor());
    }

    private ListenableFuture<AgentResponse> visited(AgentResponse response) {
        this.destination.register(RxListenableFutureInvokerProvider.class);
        ListenableFuture visited = ((RxListenableFutureInvoker)this.destination.path("visited").request().header("Rx-User", (Object)"Guava").rx(RxListenableFutureInvoker.class)).get((GenericType)new /* Unavailable Anonymous Inner Class!! */);
        return Futures.transform((ListenableFuture)visited, destinations -> {
            response.setVisited(destinations);
            return response;
        }, (Executor)Executors.newSingleThreadExecutor());
    }

    private ListenableFuture<AgentResponse> recommended(AgentResponse response) {
        this.destination.register(RxListenableFutureInvokerProvider.class);
        ListenableFuture destinations = ((RxListenableFutureInvoker)this.destination.path("recommended").request().header("Rx-User", (Object)"Guava").rx(RxListenableFutureInvoker.class)).get((GenericType)new /* Unavailable Anonymous Inner Class!! */);
        ListenableFuture recommendations = Futures.transform((ListenableFuture)destinations, destinationList -> {
            List recommendationList = destinationList.stream().map(destination -> new Recommendation(destination.getDestination(), null, 0)).collect(Collectors.toList());
            return recommendationList;
        }, (Executor)Executors.newSingleThreadExecutor());
        ListenableFuture filledRecommendations = Futures.successfulAsList(Arrays.asList(this.forecasts(recommendations), this.calculations(recommendations)));
        return Futures.transform((ListenableFuture)filledRecommendations, input -> {
            response.setRecommended((List)input.get(0));
            return response;
        }, (Executor)Executors.newSingleThreadExecutor());
    }

    private ListenableFuture<List<Recommendation>> forecasts(ListenableFuture<List<Recommendation>> recommendations) {
        this.forecast.register(RxListenableFutureInvokerProvider.class);
        return Futures.transform(recommendations, list -> (List)Futures.successfulAsList((Iterable)list.stream().map(recommendation -> Futures.transform((ListenableFuture)((RxListenableFutureInvoker)this.forecast.resolveTemplate("destination", (Object)recommendation.getDestination()).request().rx(RxListenableFutureInvoker.class)).get(Forecast.class), forecast -> {
            recommendation.setForecast(forecast.getForecast());
            return recommendation;
        }, (Executor)Executors.newSingleThreadExecutor())).collect(Collectors.toList())), (Executor)Executors.newSingleThreadExecutor());
    }

    private ListenableFuture<List<Recommendation>> calculations(ListenableFuture<List<Recommendation>> recommendations) {
        this.calculation.register(RxListenableFutureInvokerProvider.class);
        return Futures.transform(recommendations, list -> (List)Futures.successfulAsList((Iterable)list.stream().map(recommendation -> Futures.transform((ListenableFuture)((RxListenableFutureInvoker)this.calculation.resolveTemplate("from", (Object)"Moon").resolveTemplate("to", (Object)recommendation.getDestination()).request().rx(RxListenableFutureInvoker.class)).get(Calculation.class), calculation -> {
            recommendation.setPrice(calculation.getPrice());
            return recommendation;
        }, (Executor)Executors.newSingleThreadExecutor())).collect(Collectors.toList())), (Executor)Executors.newSingleThreadExecutor());
    }
}

