/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.GenericType;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Singleton;
import org.glassfish.jersey.client.rx.rxjava2.RxFlowableInvoker;
import org.glassfish.jersey.client.rx.rxjava2.RxFlowableInvokerProvider;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.examples.rx.domain.Calculation;
import org.glassfish.jersey.examples.rx.domain.Destination;
import org.glassfish.jersey.examples.rx.domain.Forecast;
import org.glassfish.jersey.examples.rx.domain.Recommendation;
import org.glassfish.jersey.server.Uri;
import org.reactivestreams.Publisher;

@Singleton
@Path(value="agent/flowable")
@Produces(value={"application/json"})
public class FlowableAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destination;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculation;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecast;

    @GET
    public void flowable(@Suspended AsyncResponse async) {
        long time = System.nanoTime();
        ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        Flowable.just((Object)new AgentResponse()).zipWith((Publisher)this.visited(errors), (agentResponse, visited) -> {
            agentResponse.setVisited(visited);
            return agentResponse;
        }).zipWith((Publisher)this.recommended(errors), (agentResponse, recommendations) -> {
            agentResponse.setRecommended(recommendations);
            return agentResponse;
        }).observeOn(Schedulers.io()).subscribe(agentResponse -> {
            agentResponse.setProcessingTime((System.nanoTime() - time) / 1000000L);
            async.resume(agentResponse);
        }, arg_0 -> ((AsyncResponse)async).resume(arg_0));
    }

    private Flowable<List<Destination>> visited(Queue<String> errors) {
        this.destination.register(RxFlowableInvokerProvider.class);
        return ((RxFlowableInvoker)this.destination.path("visited").request().header("Rx-User", (Object)"RxJava2").rx(RxFlowableInvoker.class)).get((GenericType)new /* Unavailable Anonymous Inner Class!! */).onErrorReturn(throwable -> {
            errors.offer("Visited: " + throwable.getMessage());
            return Collections.emptyList();
        });
    }

    private Flowable<List<Recommendation>> recommended(Queue<String> errors) {
        this.destination.register(RxFlowableInvokerProvider.class);
        Flowable recommended = ((RxFlowableInvoker)this.destination.path("recommended").request().header("Rx-User", (Object)"RxJava2").rx(RxFlowableInvoker.class)).get((GenericType)new /* Unavailable Anonymous Inner Class!! */).onErrorReturn(throwable -> {
            errors.offer("Recommended: " + throwable.getMessage());
            return Collections.emptyList();
        }).flatMap(Flowable::fromIterable).cache();
        this.forecast.register(RxFlowableInvokerProvider.class);
        Flowable forecasts = recommended.flatMap(destination -> ((RxFlowableInvoker)this.forecast.resolveTemplate("destination", (Object)destination.getDestination()).request().rx(RxFlowableInvoker.class)).get(Forecast.class).onErrorReturn(throwable -> {
            errors.offer("Forecast: " + throwable.getMessage());
            return new Forecast(destination.getDestination(), "N/A");
        }));
        this.calculation.register(RxFlowableInvokerProvider.class);
        Flowable calculations = recommended.flatMap(destination -> ((RxFlowableInvoker)this.calculation.resolveTemplate("from", (Object)"Moon").resolveTemplate("to", (Object)destination.getDestination()).request().rx(RxFlowableInvoker.class)).get(Calculation.class).onErrorReturn(throwable -> {
            errors.offer("Calculation: " + throwable.getMessage());
            return new Calculation("Moon", destination.getDestination(), -1);
        }));
        return Flowable.zip((Publisher)recommended, (Publisher)forecasts, (Publisher)calculations, Recommendation::new).buffer(Integer.MAX_VALUE);
    }
}

