/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.GenericType;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Singleton;
import org.glassfish.jersey.client.rx.rxjava.RxObservableInvoker;
import org.glassfish.jersey.client.rx.rxjava.RxObservableInvokerProvider;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.examples.rx.domain.Calculation;
import org.glassfish.jersey.examples.rx.domain.Destination;
import org.glassfish.jersey.examples.rx.domain.Forecast;
import org.glassfish.jersey.examples.rx.domain.Recommendation;
import org.glassfish.jersey.server.Uri;
import rx.Observable;
import rx.schedulers.Schedulers;

@Singleton
@Path(value="agent/observable")
@Produces(value={"application/json"})
public class ObservableAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destination;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculation;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecast;

    @GET
    public void observable(@Suspended AsyncResponse async) {
        long time = System.nanoTime();
        ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        Observable.just((Object)new AgentResponse()).zipWith(this.visited(errors), (response, visited) -> {
            response.setVisited(visited);
            return response;
        }).zipWith(this.recommended(errors), (response, recommendations) -> {
            response.setRecommended(recommendations);
            return response;
        }).observeOn(Schedulers.io()).subscribe(response -> {
            response.setProcessingTime((System.nanoTime() - time) / 1000000L);
            async.resume(response);
        }, arg_0 -> ((AsyncResponse)async).resume(arg_0));
    }

    private Observable<List<Destination>> visited(Queue<String> errors) {
        this.destination.register(RxObservableInvokerProvider.class);
        return ((RxObservableInvoker)this.destination.path("visited").request().header("Rx-User", (Object)"RxJava").rx(RxObservableInvoker.class)).get((GenericType)new /* Unavailable Anonymous Inner Class!! */).onErrorReturn(throwable -> {
            errors.offer("Visited: " + throwable.getMessage());
            return Collections.emptyList();
        });
    }

    private Observable<List<Recommendation>> recommended(Queue<String> errors) {
        this.destination.register(RxObservableInvokerProvider.class);
        Observable recommended = ((RxObservableInvoker)this.destination.path("recommended").request().header("Rx-User", (Object)"RxJava").rx(RxObservableInvoker.class)).get((GenericType)new /* Unavailable Anonymous Inner Class!! */).onErrorReturn(throwable -> {
            errors.offer("Recommended: " + throwable.getMessage());
            return Collections.emptyList();
        }).flatMap(Observable::from).cache();
        this.forecast.register(RxObservableInvokerProvider.class);
        Observable forecasts = recommended.flatMap(destination -> ((RxObservableInvoker)this.forecast.resolveTemplate("destination", (Object)destination.getDestination()).request().rx(RxObservableInvoker.class)).get(Forecast.class).onErrorReturn(throwable -> {
            errors.offer("Forecast: " + throwable.getMessage());
            return new Forecast(destination.getDestination(), "N/A");
        }));
        this.calculation.register(RxObservableInvokerProvider.class);
        Observable calculations = recommended.flatMap(destination -> ((RxObservableInvoker)this.calculation.resolveTemplate("from", (Object)"Moon").resolveTemplate("to", (Object)destination.getDestination()).request().rx(RxObservableInvoker.class)).get(Calculation.class).onErrorReturn(throwable -> {
            errors.offer("Calculation: " + throwable.getMessage());
            return new Calculation("Moon", destination.getDestination(), -1);
        }));
        return Observable.zip((Observable)recommended, (Observable)forecasts, (Observable)calculations, Recommendation::new).toList();
    }
}

