/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ManagedAsync;
import org.glassfish.jersey.server.Uri;

@Path(value="agent/async")
@Produces(value={"application/json"})
public class AsyncAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destination;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculation;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecast;
    private final ExecutorService executor = new ScheduledThreadPoolExecutor(20, new ThreadFactoryBuilder().setNameFormat("jersey-rx-client-async-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build());

    @GET
    @ManagedAsync
    public void async(@Suspended AsyncResponse async) {
        long time = System.nanoTime();
        AgentResponse response = new AgentResponse();
        CountDownLatch outerLatch = new CountDownLatch(2);
        ConcurrentLinkedQueue<String> errors = new ConcurrentLinkedQueue<String>();
        this.destination.path("visited").request().header("Rx-User", (Object)"Async").async().get((InvocationCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.destination.path("recommended").request().header("Rx-User", (Object)"Async").async().get((InvocationCallback)new /* Unavailable Anonymous Inner Class!! */);
        try {
            if (!outerLatch.await(10L, TimeUnit.SECONDS)) {
                errors.offer("Outer: Waiting for requests to complete has timed out.");
            }
        }
        catch (InterruptedException e) {
            errors.offer("Outer: Waiting for requests to complete has been interrupted.");
        }
        response.setProcessingTime((System.nanoTime() - time) / 1000000L);
        async.resume((Object)response);
    }

    static /* synthetic */ WebTarget access$000(AsyncAgentResource x0) {
        return x0.forecast;
    }

    static /* synthetic */ WebTarget access$100(AsyncAgentResource x0) {
        return x0.calculation;
    }
}

