/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.rx.agent;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.glassfish.jersey.examples.rx.domain.AgentResponse;
import org.glassfish.jersey.examples.rx.domain.Calculation;
import org.glassfish.jersey.examples.rx.domain.Destination;
import org.glassfish.jersey.examples.rx.domain.Forecast;
import org.glassfish.jersey.examples.rx.domain.Recommendation;
import org.glassfish.jersey.server.Uri;

@Path(value="agent/sync")
@Produces(value={"application/json"})
public class SyncAgentResource {
    @Uri(value="remote/destination")
    private WebTarget destination;
    @Uri(value="remote/calculation/from/{from}/to/{to}")
    private WebTarget calculation;
    @Uri(value="remote/forecast/{destination}")
    private WebTarget forecast;

    @GET
    public AgentResponse sync() {
        long time = System.nanoTime();
        AgentResponse response = new AgentResponse();
        ConcurrentLinkedQueue<CallSite> errors = new ConcurrentLinkedQueue<CallSite>();
        try {
            response.setVisited((List)this.destination.path("visited").request().header("Rx-User", (Object)"Sync").get((GenericType)new /* Unavailable Anonymous Inner Class!! */));
        }
        catch (Throwable throwable) {
            errors.offer((CallSite)((Object)("Visited: " + throwable.getMessage())));
        }
        List recommended = Collections.emptyList();
        try {
            recommended = (List)this.destination.path("recommended").request().header("Rx-User", (Object)"Sync").get((GenericType)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable throwable) {
            errors.offer((CallSite)((Object)("Recommended: " + throwable.getMessage())));
        }
        HashMap<String, Forecast> forecasts = new HashMap<String, Forecast>();
        for (Destination dest : recommended) {
            try {
                forecasts.put(dest.getDestination(), (Forecast)this.forecast.resolveTemplate("destination", (Object)dest.getDestination()).request().get(Forecast.class));
            }
            catch (Throwable throwable) {
                errors.offer((CallSite)((Object)("Forecast: " + throwable.getMessage())));
            }
        }
        HashMap calculations = new HashMap();
        recommended.stream().forEach(destination -> {
            try {
                calculations.put(destination.getDestination(), (Calculation)this.calculation.resolveTemplate("from", (Object)"Moon").resolveTemplate("to", (Object)destination.getDestination()).request().get(Calculation.class));
            }
            catch (Throwable throwable) {
                errors.offer((CallSite)((Object)("Calculation: " + throwable.getMessage())));
            }
        });
        ArrayList<Recommendation> recommendations = new ArrayList<Recommendation>(recommended.size());
        for (Destination dest : recommended) {
            Forecast fore = (Forecast)forecasts.get(dest.getDestination());
            Calculation calc = (Calculation)calculations.get(dest.getDestination());
            recommendations.add(new Recommendation(dest.getDestination(), fore != null ? fore.getForecast() : "N/A", calc != null ? calc.getPrice() : -1));
        }
        response.setRecommended(recommendations);
        response.setProcessingTime((System.nanoTime() - time) / 1000000L);
        return response;
    }
}

