/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async.managed;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.Suspend;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.ExecutionContext;
import org.glassfish.jersey.examples.server.async.managed.Message;

@Path(value="chat")
@Produces(value={"application/json"})
public class ChatResource {
    private static final BlockingQueue<ExecutionContext> suspended = new ArrayBlockingQueue<ExecutionContext>(5);
    @Context
    ExecutionContext ctx;

    @GET
    @Suspend
    public void getMessage() throws InterruptedException {
        suspended.put(this.ctx);
    }

    @POST
    public String postMessage(Message message) throws InterruptedException {
        ExecutionContext resumeCtx = suspended.take();
        resumeCtx.resume((Object)message);
        return "Sent!";
    }
}

