/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async.managed;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.examples.server.async.managed.ChatResource;
import org.glassfish.jersey.examples.server.async.managed.SimpleJerseyExecutorManagedLongRunningResource;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ServerExecutorsFactory;
import org.glassfish.jersey.spi.RequestExecutorsProvider;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ASYNC_LONG_RUNNING_MANAGED_OP_PATH = "managedasync/longrunning";

    public static void main(String[] args) {
        try {
            System.out.println("\"Custom Executor Managed Async Resources\" Jersey Example App");
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)App.create());
            System.out.println(String.format("Application started.\nTo test long-running asynchronous operation resource, try %s%s\nTo test async chat resource, try %s%s\nHit enter to stop it...", BASE_URI, ASYNC_LONG_RUNNING_MANAGED_OP_PATH, BASE_URI, "chat"));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig create() {
        return new ResourceConfig().addClasses(new Class[]{ChatResource.class, SimpleJerseyExecutorManagedLongRunningResource.class, RequestExecProvider.class}).addSingletons(new Object[]{new LoggingFilter(Logger.getLogger(App.class.getName()), true)}).addBinders(new Binder[]{new JacksonBinder(), new ServerExecutorsFactory.ServerExecutorBinder()});
    }

    public static class RequestExecProvider
    implements RequestExecutorsProvider {
        public ExecutorService getRequestingExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("custom-request-executor-%d").build());
        }
    }
}

