/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.examples.server.async.Main;
import org.jdesktop.layout.GroupLayout;

public class MainWindow
extends JFrame {
    private JRadioButton asyncRadio;
    private JLabel finishStatusLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel messagePanel;
    private JTextField requestCountField;
    private JButton runButton;
    private JLabel successRateStatusLabel;
    private ButtonGroup syncAsyncSwitchGroup;
    private JRadioButton syncRadio;
    private JTextField uriField;
    private final Color PROGRESS_COLOR = new Color(255, 255, 0);
    private final Color ERROR_COLOR = new Color(255, 0, 0);
    private final Color SUCCESS_COLOR = new Color(0, 255, 0);

    public MainWindow() {
        this.initComponents();
        this.uriField.setText("http://localhost:8080/server-async-standalone-webapp/");
        ((FlowLayout)this.messagePanel.getLayout()).setAlignment(3);
        this.messagePanel.removeAll();
        this.messagePanel.revalidate();
    }

    private void initComponents() {
        this.syncAsyncSwitchGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.requestCountField = new JTextField();
        this.syncRadio = new JRadioButton();
        this.asyncRadio = new JRadioButton();
        this.uriField = new JTextField();
        this.jLabel2 = new JLabel();
        this.runButton = new JButton();
        this.messagePanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel2 = new JPanel();
        this.finishStatusLabel = new JLabel();
        this.successRateStatusLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMaximumSize(new Dimension(480, 600));
        this.setMinimumSize(new Dimension(480, 600));
        this.setResizable(false);
        this.jLabel1.setText("Number of requests");
        this.requestCountField.setHorizontalAlignment(4);
        this.requestCountField.setText("10");
        this.syncAsyncSwitchGroup.add(this.syncRadio);
        this.syncRadio.setText("sync");
        this.syncAsyncSwitchGroup.add(this.asyncRadio);
        this.asyncRadio.setSelected(true);
        this.asyncRadio.setText("async");
        this.uriField.setText("jTextField2");
        this.jLabel2.setText("Base web app URL");
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.runButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel1).add(2, (Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.requestCountField).addPreferredGap(0).add((Component)this.syncRadio).addPreferredGap(0).add((Component)this.asyncRadio).add(24, 24, 24).add((Component)this.runButton)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.uriField).addContainerGap()))));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.uriField, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.requestCountField, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.syncRadio).add((Component)this.asyncRadio).add((Component)this.runButton))));
        this.messagePanel.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setBackground(new Color(255, 255, 0));
        this.jLabel3.setText("   ");
        this.jLabel3.setToolTipText("Running...");
        this.jLabel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel3.setOpaque(true);
        this.messagePanel.add(this.jLabel3);
        this.jLabel4.setBackground(new Color(255, 255, 0));
        this.jLabel4.setText("   ");
        this.jLabel4.setToolTipText("Running...");
        this.jLabel4.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel4.setOpaque(true);
        this.messagePanel.add(this.jLabel4);
        this.finishStatusLabel.setText(" ");
        this.successRateStatusLabel.setText(" ");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.finishStatusLabel, -1, -1, Short.MAX_VALUE).add((Component)this.successRateStatusLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.finishStatusLabel).addPreferredGap(0).add((Component)this.successRateStatusLabel).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.messagePanel, -2, 468, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.messagePanel, -1, 456, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        final Main.Config config = new Main.Config(this.uriField.getText(), this.syncRadio.isSelected(), Integer.parseInt(this.requestCountField.getText()));
        this.runButton.setEnabled(false);
        this.finishStatusLabel.setText(" ");
        this.successRateStatusLabel.setText(" ");
        this.messagePanel.removeAll();
        this.messagePanel.revalidate();
        this.messagePanel.repaint();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.sendMessages(config);
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow mainWindow = new MainWindow();
                mainWindow.setLocationRelativeTo(null);
                mainWindow.setVisible(true);
            }
        });
    }

    private JLabel createRequestStatusLabel() {
        final JLabel label = new JLabel("   ");
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                label.setBackground(MainWindow.this.PROGRESS_COLOR);
                label.setToolTipText("Running...");
                label.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
                label.setOpaque(true);
                MainWindow.this.messagePanel.add(label);
                MainWindow.this.messagePanel.revalidate();
            }
        });
        return label;
    }

    private void invokeAndWait(Runnable event) {
        try {
            EventQueue.invokeAndWait(event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMessages(final Main.Config config) {
        Client client = ClientBuilder.newClient();
        final WebTarget echoResource = client.target(config.baseUri).path("long-running/{mode}/{echo}").resolveTemplate("mode", (Object)(config.sync ? "sync" : "async"));
        final CountDownLatch latch = new CountDownLatch(config.requests);
        final AtomicInteger requestCounter = new AtomicInteger(0);
        final long tic = System.currentTimeMillis();
        int i = 0;
        while (i < config.requests) {
            final int reqId = i++;
            final JLabel requestStatusLabel = this.createRequestStatusLabel();
            echoResource.resolveTemplate("echo", (Object)reqId).request().async().get((InvocationCallback)new InvocationCallback<String>(){
                private final AtomicInteger retries = new AtomicInteger(0);

                public void completed(final String response) {
                    MainWindow.this.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            String requestId = Integer.toString(reqId);
                            if (requestId.equals(response)) {
                                requestStatusLabel.setBackground(MainWindow.this.SUCCESS_COLOR);
                                requestStatusLabel.setToolTipText(requestId);
                                requestCounter.incrementAndGet();
                            } else {
                                requestStatusLabel.setBackground(MainWindow.this.ERROR_COLOR);
                                requestStatusLabel.setToolTipText(String.format("Echo response '%s' not equal to request '%s'", response, requestId));
                            }
                            latch.countDown();
                        }
                    });
                }

                public void failed(final Throwable error) {
                    if (error.getCause() instanceof IOException && this.retries.getAndIncrement() < 3) {
                        echoResource.resolveTemplate("echo", (Object)reqId).request().async().get((InvocationCallback)this);
                    } else {
                        MainWindow.this.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                requestStatusLabel.setBackground(MainWindow.this.ERROR_COLOR);
                                requestStatusLabel.setToolTipText(String.format("Request '%d' has failed: %s", reqId, error.toString()));
                                latch.countDown();
                            }
                        });
                    }
                }
            });
        }
        try {
            if (!latch.await(60L, TimeUnit.SECONDS)) {
                System.out.println("Waiting for requests to complete has timed out.");
            }
        }
        catch (InterruptedException e) {
            System.out.println("Waiting for requests to complete has been interrupted.");
        }
        final long toc = System.currentTimeMillis();
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.finishStatusLabel.setText(String.format("Execution finished in %d ms.", toc - tic));
                MainWindow.this.successRateStatusLabel.setText(String.format("Success rate: %6.2f %%", (double)requestCounter.get() / (double)config.requests * 100.0));
            }
        });
        client.close();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.runButton.setEnabled(true);
            }
        });
    }
}

