/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.Suspend;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.ExecutionContext;

@Path(value="async/longrunning")
@Produces(value={"text/plain"})
public class SimpleLongRunningResource {
    public static final String NOTIFICATION_RESPONSE = "Hello async world!";
    private static final Logger LOGGER = Logger.getLogger(SimpleLongRunningResource.class.getName());
    private static final int SLEEP_TIME_IN_MILLIS = 1000;
    private static final ExecutorService TASK_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("long-running-resource-executor-%d").build());
    @Context
    private ExecutionContext ctx;

    @GET
    @Suspend
    public void longGet() {
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
                }
                SimpleLongRunningResource.this.ctx.resume((Object)SimpleLongRunningResource.NOTIFICATION_RESPONSE);
            }
        });
    }
}

