/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import deprecated.javax.ws.rs.ExecutionContext;
import deprecated.javax.ws.rs.Suspend;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

@Path(value="async/messaging/fireAndForget")
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
public class FireAndForgetChatResource {
    public static final String POST_NOTIFICATION_RESPONSE = "Message sent";
    private static final Logger LOGGER = Logger.getLogger(FireAndForgetChatResource.class.getName());
    private static final Level DEBUG = Level.INFO;
    private static final ExecutorService QUEUE_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("fire&forget-chat-resource-executor-%d").build());
    private static final BlockingQueue<ExecutionContext> suspended = new ArrayBlockingQueue<ExecutionContext>(5);
    @Context
    ExecutionContext ctx;

    @GET
    @Suspend
    public void pickUpMessage(final @QueryParam(value="id") String messageId) throws InterruptedException {
        LOGGER.log(DEBUG, "Received GET ({0}) with context {1} on thread {2}", new Object[]{messageId, this.ctx.toString(), Thread.currentThread().getName()});
        QUEUE_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    suspended.put(FireAndForgetChatResource.this.ctx);
                    LOGGER.log(DEBUG, "GET ({0}) context {1} scheduled for resume.", new Object[]{messageId, FireAndForgetChatResource.this.ctx.toString()});
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Waiting for a message pick-up interrupted. Cancelling context" + FireAndForgetChatResource.this.ctx.toString(), ex);
                    FireAndForgetChatResource.this.ctx.cancel();
                }
            }
        });
    }

    @POST
    public String postMessage(final String message) throws InterruptedException {
        System.out.println(String.format("Received POST '%s' with context %s on thread %s", message, this.ctx.toString(), Thread.currentThread().getName()));
        QUEUE_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutionContext resumeCtx = (ExecutionContext)suspended.take();
                    LOGGER.log(DEBUG, "Resuming GET context {0}' with a message '{1}' on thread {2}", new Object[]{resumeCtx.toString(), message, Thread.currentThread().getName()});
                    resumeCtx.resume((Object)message);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Waiting for a sending a message '" + message + "' has been interrupted.", ex);
                }
            }
        });
        return POST_NOTIFICATION_RESPONSE;
    }
}

