/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import deprecated.javax.ws.rs.ExecutionContext;
import deprecated.javax.ws.rs.Suspend;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

@Produces(value={"text/plain"})
public class LongRunningAsyncOperationResource {
    public static final String NOTIFICATION_RESPONSE = "Hello async world!";
    private static final Logger LOGGER = Logger.getLogger(LongRunningAsyncOperationResource.class.getName());
    private static final int SLEEP_TIME_IN_MILLIS = 1000;
    private static final ExecutorService TASK_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("long-running-resource-executor-%d").build());
    @Context
    private ExecutionContext ctx;

    @GET
    @Path(value="basicSyncExample")
    public String basicSyncExample() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
        }
        return NOTIFICATION_RESPONSE;
    }

    @GET
    @Suspend(timeOut=15L, timeUnit=TimeUnit.SECONDS)
    @Path(value="suspendViaAnnotation")
    public void suspendViaAnnotationExample() {
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
                }
                LongRunningAsyncOperationResource.this.ctx.resume((Object)LongRunningAsyncOperationResource.NOTIFICATION_RESPONSE);
            }
        });
    }

    @GET
    @Suspend(timeOut=15L, timeUnit=TimeUnit.SECONDS)
    @Path(value="suspendViaAnnotation2")
    public void suspendViaAnnotationExample2(final @Context ExecutionContext ctx2) {
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
                }
                ctx2.resume((Object)LongRunningAsyncOperationResource.NOTIFICATION_RESPONSE);
            }
        });
    }

    @GET
    @Path(value="suspendViaContext")
    public String suspendViaContextExample(final @QueryParam(value="query") String query) {
        if (!this.isComplex(query)) {
            return "Simple result for " + query;
        }
        this.ctx.suspend();
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
                }
                LongRunningAsyncOperationResource.this.ctx.resume((Object)("Complex result for " + query));
            }
        });
        return null;
    }

    private boolean isComplex(String query) {
        return "complex".equalsIgnoreCase(query);
    }

    @GET
    @Path(value="timeoutPropagated")
    @Suspend(timeOut=15000L)
    public void timeoutValueConflict_PropagationExample() {
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
                }
                LongRunningAsyncOperationResource.this.ctx.resume((Object)LongRunningAsyncOperationResource.NOTIFICATION_RESPONSE);
            }
        });
        this.ctx.suspend();
    }

    @GET
    @Path(value="timeoutOverriden")
    @Suspend(timeOut=15000L)
    public void timeoutValueConflict_OverridingExample(@QueryParam(value="timeOut") Long timeOut, @QueryParam(value="timeUnit") TimeUnit timeUnit) {
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
                }
                LongRunningAsyncOperationResource.this.ctx.resume((Object)LongRunningAsyncOperationResource.NOTIFICATION_RESPONSE);
            }
        });
        if (timeOut != null && timeUnit != null) {
            this.ctx.suspend(timeOut.longValue(), timeUnit);
        }
    }

    @GET
    @Path(value="suspendHandleUsage")
    public void suspendHandleUsageExample() {
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Response processing interrupted", ex);
                }
                LongRunningAsyncOperationResource.this.ctx.resume((Object)LongRunningAsyncOperationResource.NOTIFICATION_RESPONSE);
            }
        });
        this.ctx.suspend();
        TASK_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                while (!LongRunningAsyncOperationResource.this.ctx.isDone()) {
                }
                LOGGER.log(Level.INFO, "Context resumed with a response!");
            }
        });
    }
}

