/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;

@Path(value="async/messaging/blocking")
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
public class BlockingPostChatResource {
    public static final String POST_NOTIFICATION_RESPONSE = "Message stored.";
    private static final Logger LOGGER = Logger.getLogger(BlockingPostChatResource.class.getName());
    private static final Level DEBUG = Level.INFO;
    private static final ExecutorService QUEUE_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("blocking-post-chat-resource-executor-%d").build());
    private static final BlockingQueue<String> messages = new ArrayBlockingQueue<String>(5);

    @GET
    public void pickUpMessage(final @Suspended AsyncResponse ar, final @QueryParam(value="id") String messageId) {
        LOGGER.log(DEBUG, "Received GET <{0}> with context {1} on thread {2}.", new Object[]{messageId, ar.toString(), Thread.currentThread().getName()});
        QUEUE_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String message = (String)messages.take();
                    LOGGER.log(DEBUG, "Resuming GET <{0}> context {1} with a message {2} on thread {3}.", new Object[]{messageId, ar.toString(), message, Thread.currentThread().getName()});
                    ar.resume((Object)message);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Waiting for a message pick-up interrupted. Cancelling context" + ar.toString(), ex);
                    ar.cancel();
                }
            }
        });
    }

    @POST
    public void postMessage(final @Suspended AsyncResponse ar, final String message) {
        LOGGER.log(DEBUG, "Received POST <{0}> with context {1} on thread {2}. Suspending the context.", new Object[]{message, ar.toString(), Thread.currentThread().getName()});
        QUEUE_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    messages.put(message);
                    LOGGER.log(DEBUG, "POSTed message <{0}> successfully queued. Resuming POST with context {1} on thread {2}.", new Object[]{message, ar.toString(), Thread.currentThread().getName()});
                    ar.resume((Object)BlockingPostChatResource.POST_NOTIFICATION_RESPONSE);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Waiting for a queueing a message '" + message + "' has been interrupted.", ex);
                    ar.resume((Throwable)ex);
                }
            }
        });
    }
}

