/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.server.async.BlockingPostChatResource;
import org.glassfish.jersey.examples.server.async.FireAndForgetChatResource;
import org.glassfish.jersey.examples.server.async.SimpleLongRunningResource;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ASYNC_MESSAGING_FIRE_N_FORGET_PATH = "async/messaging/fireAndForget";
    public static final String ASYNC_MESSAGING_BLOCKING_PATH = "async/messaging/blocking";
    public static final String ASYNC_LONG_RUNNING_OP_PATH = "async/longrunning";

    public static void main(String[] args) {
        try {
            System.out.println("\"Async resources\" Jersey Example App");
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)App.create());
            System.out.println(String.format("Application started.\nTo test simple, non-blocking asynchronous messaging resource, try %s%s\nTo test blocking version of asynchronous messaging resource, try %s%s\nTo test long-running asynchronous operation resource, try %s%s\nHit enter to stop it...", BASE_URI, ASYNC_MESSAGING_FIRE_N_FORGET_PATH, BASE_URI, ASYNC_MESSAGING_BLOCKING_PATH, BASE_URI, ASYNC_LONG_RUNNING_OP_PATH));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig create() {
        ResourceConfig resourceConfig = new ResourceConfig().registerClasses(new Class[]{BlockingPostChatResource.class, FireAndForgetChatResource.class, SimpleLongRunningResource.class}).registerInstances(new Object[]{new LoggingFilter(Logger.getLogger(App.class.getName()), true)});
        return resourceConfig;
    }
}

