/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import jersey.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;

@Path(value="async/messaging/fireAndForget")
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
public class FireAndForgetChatResource {
    public static final String POST_NOTIFICATION_RESPONSE = "Message sent";
    private static final Logger LOGGER = Logger.getLogger(FireAndForgetChatResource.class.getName());
    private static final Level DEBUG = Level.INFO;
    private static final ExecutorService QUEUE_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("fire&forget-chat-resource-executor-%d").build());
    private static final BlockingQueue<AsyncResponse> suspended = new ArrayBlockingQueue<AsyncResponse>(5);

    @GET
    public void pickUpMessage(final @Suspended AsyncResponse ar, final @QueryParam(value="id") String messageId) throws InterruptedException {
        LOGGER.log(DEBUG, "Received GET <{0}> with context {1} on thread {2}.", new Object[]{messageId, ar.toString(), Thread.currentThread().getName()});
        QUEUE_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    suspended.put(ar);
                    LOGGER.log(DEBUG, "GET <{0}> context {1} scheduled for resume.", new Object[]{messageId, ar.toString()});
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Waiting for a message pick-up interrupted. Cancelling context" + ar.toString(), ex);
                    ar.cancel();
                }
            }
        });
    }

    @POST
    public String postMessage(final String message) throws InterruptedException {
        LOGGER.log(DEBUG, "Received POSTed message <{0}> on thread {1}.", new Object[]{message, Thread.currentThread().getName()});
        QUEUE_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncResponse suspendedResponse = (AsyncResponse)suspended.take();
                    LOGGER.log(DEBUG, "Resuming GET context {0} with a message <{1}> on thread {2}.", new Object[]{suspendedResponse.toString(), message, Thread.currentThread().getName()});
                    suspendedResponse.resume((Object)message);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, "Waiting for a sending a message <" + message + "> has been interrupted.", ex);
                }
            }
        });
        return POST_NOTIFICATION_RESPONSE;
    }
}

