/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sse.jaxrs;

import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;

@Path(value="server-sent-events")
public class JaxRsServerSentEventsResource {
    private static volatile SseEventSink eventSink = null;

    @GET
    @Produces(value={"text/event-stream"})
    public void getMessageQueue(@Context SseEventSink sink) {
        eventSink = sink;
    }

    @POST
    public void addMessage(String message, @Context Sse sse) throws IOException {
        SseEventSink localSink = eventSink;
        if (localSink != null) {
            localSink.send(sse.newEventBuilder().name("custom-message").data(String.class, (Object)message).build());
        }
    }

    @DELETE
    public void close() throws IOException {
        SseEventSink localSink = eventSink;
        if (localSink != null) {
            eventSink.close();
        }
        eventSink = null;
    }

    @POST
    @Path(value="domains/{id}")
    @Produces(value={"text/event-stream"})
    public void startDomain(@PathParam(value="id") String id, @Context SseEventSink domainSink, @Context Sse sse) {
        new Thread(() -> {
            try {
                domainSink.send(sse.newEventBuilder().name("domain-progress").data(String.class, (Object)("starting domain " + id + " ...")).build());
                Thread.sleep(200L);
                domainSink.send(sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"50%").build());
                Thread.sleep(200L);
                domainSink.send(sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"60%").build());
                Thread.sleep(200L);
                domainSink.send(sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"70%").build());
                Thread.sleep(200L);
                domainSink.send(sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"99%").build());
                Thread.sleep(200L);
                domainSink.send(sse.newEventBuilder().name("domain-progress").data(String.class, (Object)"done").build());
                domainSink.close();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }
}

