/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sse.jersey;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;

@Path(value="server-sent-events")
public class ServerSentEventsResource {
    private static volatile EventOutput eventOutput = new EventOutput();

    @GET
    @Produces(value={"text/event-stream"})
    public EventOutput getMessageQueue() {
        return eventOutput;
    }

    @POST
    public void addMessage(String message) throws IOException {
        EventOutput localOutput = eventOutput;
        if (localOutput != null) {
            eventOutput.write((Object)new OutboundEvent.Builder().name("custom-message").data(String.class, (Object)message).build());
        }
    }

    @DELETE
    public void close() throws IOException {
        EventOutput localOutput = eventOutput;
        if (localOutput != null) {
            eventOutput.close();
        }
        ServerSentEventsResource.setEventOutput(new EventOutput());
    }

    @POST
    @Path(value="domains/{id}")
    @Produces(value={"text/event-stream"})
    public EventOutput startDomain(final @PathParam(value="id") String id) {
        final EventOutput seq = new EventOutput();
        new Thread(){

            @Override
            public void run() {
                try {
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)("starting domain " + id + " ...")).build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"50%").build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"60%").build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"70%").build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"99%").build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"done").build());
                    seq.close();
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        return seq;
    }

    private static void setEventOutput(EventOutput eventOutput) {
        ServerSentEventsResource.eventOutput = eventOutput;
    }
}

