/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sse.jersey;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.ChunkedOutput;

@Path(value="domain")
public class DomainResource {
    private static final Map<Integer, Process> processes = new ConcurrentHashMap<Integer, Process>();

    @Path(value="start")
    @POST
    public Response post(@DefaultValue(value="0") @QueryParam(value="testSources") int testSources) {
        Process process = new Process(testSources);
        processes.put(process.getId(), process);
        Executors.newSingleThreadExecutor().execute(process);
        URI processIdUri = UriBuilder.fromResource(DomainResource.class).path("process/{id}").build(new Object[]{process.getId()});
        return Response.created((URI)processIdUri).build();
    }

    @Path(value="process/{id}")
    @Produces(value={"text/event-stream"})
    @GET
    public EventOutput getProgress(@PathParam(value="id") int id, @DefaultValue(value="false") @QueryParam(value="testSource") boolean testSource) {
        Process process = processes.get(id);
        if (process != null) {
            if (testSource) {
                process.release();
            }
            EventOutput eventOutput = new EventOutput();
            process.getBroadcaster().add((ChunkedOutput)eventOutput);
            return eventOutput;
        }
        throw new NotFoundException();
    }

    static class Process
    implements Runnable {
        private static final AtomicInteger counter = new AtomicInteger(0);
        private final int id;
        private final CountDownLatch latch;
        private final SseBroadcaster broadcaster = new SseBroadcaster(){

            public void onException(ChunkedOutput<OutboundEvent> outboundEventChunkedOutput, Exception exception) {
                exception.printStackTrace();
            }
        };

        public Process(int testReceivers) {
            this.id = counter.incrementAndGet();
            this.latch = testReceivers > 0 ? new CountDownLatch(testReceivers) : null;
        }

        public int getId() {
            return this.id;
        }

        public SseBroadcaster getBroadcaster() {
            return this.broadcaster;
        }

        public boolean release() {
            if (this.latch == null) {
                return false;
            }
            this.latch.countDown();
            return true;
        }

        @Override
        public void run() {
            try {
                if (this.latch != null) {
                    this.latch.await(5L, TimeUnit.SECONDS);
                }
                this.broadcaster.broadcast((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)("starting domain " + this.id + " ...")).build());
                this.broadcaster.broadcast((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"50%").build());
                this.broadcaster.broadcast((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"60%").build());
                this.broadcaster.broadcast((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"70%").build());
                this.broadcaster.broadcast((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"99%").build());
                this.broadcaster.broadcast((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"done").build());
                this.broadcaster.closeAll();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

