/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sse;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.glassfish.jersey.media.sse.EventChannel;

@Path(value="server-sent-events")
public class ServerSentEventsResource {
    private static EventChannel eventChannel = new EventChannel();

    @GET
    @Produces(value={"text/event-stream"})
    public EventChannel getMessageQueue() {
        return eventChannel;
    }

    @POST
    public void addMessage(String message) {
        eventChannel.write("custom-message", (Object)message, String.class);
    }

    @DELETE
    public void close() {
        eventChannel.close();
    }

    @POST
    @Path(value="domains/{id}")
    @Produces(value={"text/event-stream"})
    public EventChannel startDomain(final @PathParam(value="id") String id) {
        final EventChannel seq = new EventChannel();
        new Thread(){

            @Override
            public void run() {
                try {
                    seq.write("domain-progress", (Object)("starting domain " + id + " ..."), String.class);
                    Thread.sleep(1000L);
                    seq.write("domain-progress", (Object)"50%", String.class);
                    Thread.sleep(1000L);
                    seq.write("domain-progress", (Object)"60%", String.class);
                    Thread.sleep(1000L);
                    seq.write("domain-progress", (Object)"70%", String.class);
                    Thread.sleep(1000L);
                    seq.write("domain-progress", (Object)"99%", String.class);
                    Thread.sleep(1000L);
                    seq.write("domain-progress", (Object)"done", String.class);
                    seq.close();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        return seq;
    }
}

