/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sse;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.media.sse.Broadcaster;
import org.glassfish.jersey.media.sse.EventChannel;
import org.glassfish.jersey.media.sse.OutboundEvent;

@Path(value="domain")
public class DomainResource {
    private static final Map<Integer, Process> processes = new HashMap<Integer, Process>();

    @Path(value="start")
    @POST
    public Response post() {
        Process process = new Process();
        processes.put(process.getId(), process);
        Executors.newCachedThreadPool().execute(process);
        return Response.created((URI)UriBuilder.fromResource(DomainResource.class).path("process/{id}").build(new Object[]{process.getId()})).build();
    }

    @Path(value="process/{id}")
    @Produces(value={"text/event-stream"})
    @GET
    public EventChannel getProgress(@PathParam(value="id") int id) {
        Process process = processes.get(id);
        if (process != null) {
            EventChannel eventChannel = new EventChannel();
            process.getBroadcaster().registerEventChannel(eventChannel);
            return eventChannel;
        }
        throw new WebApplicationException(404);
    }

    static class Process
    implements Runnable {
        private static final AtomicInteger counter = new AtomicInteger(0);
        private final int id;
        private final Broadcaster broadcaster = new Broadcaster();

        public Process() {
            this.id = counter.incrementAndGet();
        }

        public int getId() {
            return this.id;
        }

        public Broadcaster getBroadcaster() {
            return this.broadcaster;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                this.broadcaster.broadcast(new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)("starting domain " + this.id + " ...")).build());
                this.broadcaster.broadcast(new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"50%").build());
                this.broadcaster.broadcast(new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"60%").build());
                this.broadcaster.broadcast(new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"70%").build());
                this.broadcaster.broadcast(new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"99%").build());
                this.broadcaster.broadcast(new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"done").build());
                this.broadcaster.close();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

