/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sse;

import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.glassfish.jersey.media.sse.EventChannel;
import org.glassfish.jersey.media.sse.OutboundEvent;

@Path(value="server-sent-events")
public class ServerSentEventsResource {
    private static EventChannel eventChannel = new EventChannel();

    @GET
    @Produces(value={"text/event-stream"})
    public EventChannel getMessageQueue() {
        return eventChannel;
    }

    @POST
    public void addMessage(String message) throws IOException {
        eventChannel.write((Object)new OutboundEvent.Builder().name("custom-message").data(String.class, (Object)message).build());
    }

    @DELETE
    public void close() throws IOException {
        eventChannel.close();
    }

    @POST
    @Path(value="domains/{id}")
    @Produces(value={"text/event-stream"})
    public EventChannel startDomain(final @PathParam(value="id") String id) {
        final EventChannel seq = new EventChannel();
        new Thread(){

            @Override
            public void run() {
                try {
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)("starting domain " + id + " ...")).build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"50%").build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"60%").build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"70%").build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"99%").build());
                    Thread.sleep(200L);
                    seq.write((Object)new OutboundEvent.Builder().name("domain-progress").data(String.class, (Object)"done").build());
                    seq.close();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        return seq;
    }
}

