/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.shortener.webapp.resource;

import java.net.URI;
import java.util.Collections;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.examples.shortener.webapp.domain.ShortenedLink;
import org.glassfish.jersey.examples.shortener.webapp.service.ShortenerService;
import org.glassfish.jersey.examples.shortener.webapp.validation.ShortenLink;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.Viewable;

@Path(value="/")
public class ShortenerResource {
    @NotNull
    @Context
    private UriInfo uriInfo;

    @GET
    @Produces(value={"text/html"})
    public Viewable form() {
        return new Viewable("/form", Collections.singletonMap("greeting", "Link Shortener"));
    }

    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Template(name="/short-link")
    @ErrorTemplate(name="/error-form")
    @Valid
    public ShortenedLink createLink(@ShortenLink @FormParam(value="link") String link) {
        return ShortenerService.shortenLink((URI)this.uriInfo.getBaseUri(), (String)link);
    }
}

