/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.console.resources;

import java.io.InputStream;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.examples.console.resources.Colours;

@Path(value="/form")
@Produces(value={"text/html"})
public class FormResource {
    private static final Colours coloursResource = new Colours();
    @Context
    HttpHeaders headers;

    @Path(value="colours")
    public Colours getColours() {
        return coloursResource;
    }

    @GET
    public Response getForm() {
        Date now = new Date();
        InputStream entity = this.getClass().getClassLoader().getResourceAsStream("form.html");
        return Response.ok((Object)entity).cookie(new NewCookie[]{new NewCookie("date", now.toString())}).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String processForm(MultivaluedMap<String, String> formData) {
        StringBuilder buf = new StringBuilder();
        buf.append("<html><head><title>Form results</title></head><body>");
        buf.append("<p>Hello, you entered the following information: </p><table border='1'>");
        for (String key : formData.keySet()) {
            if (key.equals("submit")) continue;
            buf.append("<tr><td>");
            buf.append(key);
            buf.append("</td><td>");
            buf.append((String)formData.getFirst((Object)key));
            buf.append("</td></tr>");
        }
        for (Cookie c : this.headers.getCookies().values()) {
            buf.append("<tr><td>Cookie: ");
            buf.append(c.getName());
            buf.append("</td><td>");
            buf.append(c.getValue());
            buf.append("</td></tr>");
        }
        buf.append("</table></body></html>");
        return buf.toString();
    }
}

