/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.console;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class App {
    public static final URI BASE_URI = App.getBaseURI();
    public static final int defaultPort = 9998;

    private static int getPort(int defaultPort) {
        String port = System.getProperty("jersey.config.test.container.port");
        if (null != port) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                System.out.println("Value of jersey.config.test.container.port property is not a valid positive integer [" + port + "]." + " Reverting to default [" + defaultPort + "].");
            }
        }
        return defaultPort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/resources").port(App.getPort(9998)).build(new Object[0]);
    }

    public static ResourceConfig createApp() {
        return new ResourceConfig().register((Object)new JettisonFeature()).packages(new String[]{"org.glassfish.jersey.examples.console"});
    }

    public static void main(String[] args) {
        try {
            System.out.println("JSON with JAXB Jersey Example App");
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)App.getBaseURI(), (ResourceConfig)App.createApp());
            System.out.println(String.format("Application started.%nTry out %s%nHit enter to stop it...", BASE_URI));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

