/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.console.resources;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Date;
import org.glassfish.jersey.examples.console.resources.Colours;

@Path(value="/form")
@Produces(value={"text/html"})
public class FormResource {
    private static final Colours coloursResource = new Colours();
    @Context
    HttpHeaders headers;

    @Path(value="colours")
    public Colours getColours() {
        return coloursResource;
    }

    @GET
    public Response getForm() {
        Date now = new Date();
        InputStream entity = this.getClass().getClassLoader().getResourceAsStream("form.html");
        return Response.ok((Object)entity).cookie(new NewCookie[]{new NewCookie("date", now.toString())}).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String processForm(MultivaluedMap<String, String> formData) {
        StringBuilder buf = new StringBuilder();
        buf.append("<html><head><title>Form results</title></head><body>");
        buf.append("<p>Hello, you entered the following information: </p><table border='1'>");
        for (String key : formData.keySet()) {
            if (key.equals("submit")) continue;
            buf.append("<tr><td>");
            buf.append(key);
            buf.append("</td><td>");
            buf.append((String)formData.getFirst((Object)key));
            buf.append("</td></tr>");
        }
        for (Cookie c : this.headers.getCookies().values()) {
            buf.append("<tr><td>Cookie: ");
            buf.append(c.getName());
            buf.append("</td><td>");
            buf.append(c.getValue());
            buf.append("</td></tr>");
        }
        buf.append("</table></body></html>");
        return buf.toString();
    }
}

