/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sparklines;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.examples.sparklines.ColorParam;
import org.glassfish.jersey.examples.sparklines.IntegerList;
import org.glassfish.jersey.examples.sparklines.Interval;

@Path(value="/")
@Produces(value={"image/png"})
public class SparklinesResource {
    List<Integer> data;
    @DefaultValue(value="20")
    @QueryParam(value="height")
    int imageHeight;
    Interval limits;
    EntityTag tag;

    public SparklinesResource(@QueryParam(value="d") IntegerList data, @DefaultValue(value="0,100") @QueryParam(value="limits") Interval limits, @Context Request request, @Context UriInfo ui) {
        Response.ResponseBuilder rb;
        if (data == null) {
            throw new WebApplicationException(400);
        }
        this.data = data;
        this.limits = limits;
        if (!limits.contains(data)) {
            throw new WebApplicationException(400);
        }
        this.tag = this.computeEntityTag(ui.getRequestUri());
        if (request.getMethod().equals("GET") && (rb = request.evaluatePreconditions(this.tag)) != null) {
            throw new WebApplicationException(rb.build());
        }
    }

    @Path(value="discrete")
    @GET
    public Response discrete(@DefaultValue(value="2") @QueryParam(value="width") int width, @DefaultValue(value="50") @QueryParam(value="upper") int upper, @DefaultValue(value="red") @QueryParam(value="upper-color") ColorParam upperColor, @DefaultValue(value="gray") @QueryParam(value="lower-color") ColorParam lowerColor) {
        BufferedImage image = new BufferedImage(this.data.size() * width - 1, this.imageHeight, 1);
        Graphics2D g = image.createGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        int gap = 4;
        float d = (float)(this.limits.width() + 1) / (float)(this.imageHeight - gap);
        int i = 0;
        int x = 0;
        int y = 0;
        while (i < this.data.size()) {
            int v = this.data.get(i);
            g.setColor(v >= upper ? upperColor : lowerColor);
            y = this.imageHeight - (int)((float)(v - this.limits.lower()) / d);
            g.drawRect(x, y - gap, width - 2, gap);
            ++i;
            x += width;
        }
        return Response.ok((Object)image).tag(this.tag).build();
    }

    @Path(value="smooth")
    @GET
    public Response smooth(@DefaultValue(value="2") @QueryParam(value="step") int step, @DefaultValue(value="true") @QueryParam(value="min-m") boolean hasMin, @DefaultValue(value="true") @QueryParam(value="max-m") boolean hasMax, @DefaultValue(value="true") @QueryParam(value="last-m") boolean hasLast, @DefaultValue(value="blue") @QueryParam(value="min-color") ColorParam minColor, @DefaultValue(value="green") @QueryParam(value="max-color") ColorParam maxColor, @DefaultValue(value="red") @QueryParam(value="last-color") ColorParam lastColor) {
        BufferedImage image = new BufferedImage(this.data.size() * step - 4, this.imageHeight, 1);
        Graphics2D g = image.createGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        g.setColor(Color.gray);
        int[] xs = new int[this.data.size()];
        int[] ys = new int[this.data.size()];
        int gap = 4;
        float d = (float)(this.limits.width() + 1) / (float)(this.imageHeight - gap);
        int i = 0;
        int x = 0;
        boolean y = false;
        while (i < this.data.size()) {
            int v = this.data.get(i);
            xs[i] = x;
            ys[i] = this.imageHeight - 3 - (int)((float)(v - this.limits.lower()) / d);
            ++i;
            x += step;
        }
        g.drawPolyline(xs, ys, this.data.size());
        if (hasMin) {
            i = this.data.indexOf(Collections.min(this.data));
            g.setColor(minColor);
            g.fillRect(xs[i] - step / 2, ys[i] - step / 2, step, step);
        }
        if (hasMax) {
            i = this.data.indexOf(Collections.max(this.data));
            g.setColor(maxColor);
            g.fillRect(xs[i] - step / 2, ys[i] - step / 2, step, step);
        }
        if (hasMax) {
            g.setColor(lastColor);
            g.fillRect(xs[xs.length - 1] - step / 2, ys[ys.length - 1] - step / 2, step, step);
        }
        return Response.ok((Object)image).tag(this.tag).build();
    }

    private EntityTag computeEntityTag(URI u) {
        return new EntityTag(this.computeDigest(u.getRawPath() + u.getRawQuery()));
    }

    private String computeDigest(String content) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] digest = md.digest(content.getBytes());
            BigInteger bi = new BigInteger(digest);
            return bi.toString(16);
        }
        catch (Exception e) {
            return "";
        }
    }
}

