/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sparklines;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.jersey.examples.sparklines.SparklinesResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.server.ResourceConfig;

public class Main {
    public static final String WEB_ROOT = "/webroot/";
    public static final String APP_PATH = "/sparklines/";
    public static final int PORT = 9998;

    public static HttpServer startServer(String webRootPath) {
        HttpServer server = new HttpServer();
        NetworkListener listener = new NetworkListener("grizzly", "localhost", 9998);
        server.addListener(listener);
        ServerConfiguration config = server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new CLStaticHttpHandler(Main.class.getClassLoader(), new String[]{WEB_ROOT}), new String[]{APP_PATH});
        config.addHttpHandler((HttpHandler)RuntimeDelegate.getInstance().createEndpoint((Application)Main.createResourceConfig(), GrizzlyHttpContainer.class), new String[]{APP_PATH});
        try {
            server.start();
        }
        catch (Exception ex) {
            throw new ProcessingException("Exception thrown when trying to start grizzly server", (Throwable)ex);
        }
        return server;
    }

    public static void main(String[] args) {
        try {
            HttpServer server = Main.startServer(args.length >= 1 ? args[0] : null);
            System.out.println(String.format("Application started.\nAccess it at %s\nHit enter to stop it...", Main.getAppUri()));
            System.in.read();
            server.shutdownNow();
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String getAppUri() {
        return String.format("http://localhost:%s%s", 9998, APP_PATH);
    }

    public static ResourceConfig createResourceConfig() {
        return new ResourceConfig().registerClasses(new Class[]{SparklinesResource.class});
    }
}

