/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sseitemstore.jaxrs;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Context;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;

@Path(value="items")
public class JaxrsItemStoreResource {
    private static final Logger LOGGER = Logger.getLogger(JaxrsItemStoreResource.class.getName());
    private static final ReentrantReadWriteLock storeLock = new ReentrantReadWriteLock();
    private static final LinkedList<String> itemStore = new LinkedList();
    private static final AtomicReference<SseBroadcaster> BROADCASTER = new AtomicReference<Object>(null);
    private final Sse sse;
    private static volatile long reconnectDelay = 0L;

    public JaxrsItemStoreResource(@Context Sse sse) {
        this.sse = sse;
    }

    @GET
    @Produces(value={"text/plain"})
    public String listItems() {
        try {
            storeLock.readLock().lock();
            String string = itemStore.toString();
            return string;
        }
        finally {
            storeLock.readLock().unlock();
        }
    }

    @POST
    @Path(value="commands")
    public String processCommand(String command) {
        if (command == null || command.isEmpty()) {
            throw new BadRequestException("No command specified.");
        }
        if ("disconnect".equals(command)) {
            this.closeBroadcaster();
            return "Disconnected.";
        }
        if ("reconnect ".length() < command.length() && command.startsWith("reconnect ")) {
            String when = command.substring("reconnect ".length());
            try {
                reconnectDelay = "now".equals(when) ? 0L : Long.parseLong(when);
                return "Reconnect strategy updated: " + when;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new BadRequestException("Command not recognized: '" + command + "'");
    }

    @GET
    @Path(value="events")
    @Produces(value={"text/event-stream"})
    public void itemEvents(@HeaderParam(value="Last-Event-ID") @DefaultValue(value="-1") int lastEventId, @Context SseEventSink eventSink) {
        if (lastEventId >= 0) {
            LOGGER.info("Received last event id :" + lastEventId);
            long delay = reconnectDelay;
            if (0L < delay) {
                LOGGER.info("Non-zero reconnect delay [" + delay + "] - responding with HTTP 503.");
                throw new ServiceUnavailableException(Long.valueOf(delay));
            }
            LOGGER.info("Zero reconnect delay - reconnecting.");
            this.replayMissedEvents(lastEventId, eventSink);
        }
        this.getBroadcaster().register(eventSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayMissedEvents(int lastEventId, SseEventSink eventSink) {
        try {
            storeLock.readLock().lock();
            int firstUnreceived = lastEventId + 1;
            int missingCount = itemStore.size() - firstUnreceived;
            if (missingCount > 0) {
                LOGGER.info("Replaying events - starting with id " + firstUnreceived);
                ListIterator it = itemStore.subList(firstUnreceived, itemStore.size()).listIterator();
                while (it.hasNext()) {
                    eventSink.send(this.createItemEvent(it.nextIndex() + firstUnreceived, (String)it.next()));
                }
            } else {
                LOGGER.info("No events to replay.");
            }
        }
        finally {
            storeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public void addItem(@FormParam(value="name") String name) {
        if (name == null) {
            return;
        }
        try {
            storeLock.writeLock().lock();
            int eventId = itemStore.size();
            itemStore.add(name);
            SseBroadcaster sseBroadcaster = this.getBroadcaster();
            sseBroadcaster.broadcast(this.createItemEvent(eventId, name));
            OutboundSseEvent event = this.sse.newEventBuilder().name("size").data(Integer.class, (Object)(eventId + 1)).build();
            sseBroadcaster.broadcast(event);
        }
        finally {
            storeLock.writeLock().unlock();
        }
    }

    private OutboundSseEvent createItemEvent(int eventId, String name) {
        Logger.getLogger(JaxrsItemStoreResource.class.getName()).info("Creating event id [" + eventId + "] name [" + name + "]");
        return this.sse.newEventBuilder().id("" + eventId).data(String.class, (Object)name).build();
    }

    private SseBroadcaster getBroadcaster() {
        SseBroadcaster sseBroadcaster = (SseBroadcaster)BROADCASTER.get();
        if (sseBroadcaster == null) {
            BROADCASTER.compareAndSet(null, this.sse.newBroadcaster());
        }
        return (SseBroadcaster)BROADCASTER.get();
    }

    private void closeBroadcaster() {
        SseBroadcaster sseBroadcaster = BROADCASTER.getAndSet(null);
        if (sseBroadcaster == null) {
            return;
        }
        sseBroadcaster.close();
    }
}

