/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sseitemstore;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseBroadcaster;

@Path(value="items")
public class ItemStoreResource {
    private static final Queue<String> ITEMS = new ConcurrentLinkedQueue();
    private static final SseBroadcaster BROADCASTER = new SseBroadcaster();

    @GET
    @Produces(value={"text/plain"})
    public String listItems() {
        return ITEMS.toString();
    }

    @GET
    @Path(value="events")
    @Produces(value={"text/event-stream"})
    public EventOutput itemEvents() {
        EventOutput eventOutput = new EventOutput();
        BROADCASTER.add(eventOutput);
        return eventOutput;
    }

    @POST
    public void addItem(@FormParam(value="name") String name) {
        ITEMS.add(name);
        BROADCASTER.broadcast((Object)new OutboundEvent.Builder().data(String.class, (Object)name).build());
        BROADCASTER.broadcast((Object)new OutboundEvent.Builder().name("size").data(Integer.class, (Object)ITEMS.size()).build());
    }
}

