/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.sseitemstore;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.ServiceUnavailableException;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.BroadcasterListener;
import org.glassfish.jersey.server.ChunkedOutput;

@Path(value="items")
public class ItemStoreResource {
    private static final Logger LOGGER = Logger.getLogger(ItemStoreResource.class.getName());
    private static final ReentrantReadWriteLock storeLock = new ReentrantReadWriteLock();
    private static final LinkedList<String> itemStore = new LinkedList();
    private static final SseBroadcaster broadcaster = new SseBroadcaster();
    private static volatile long reconnectDelay;

    @GET
    @Produces(value={"text/plain"})
    public String listItems() {
        try {
            storeLock.readLock().lock();
            String string = itemStore.toString();
            return string;
        }
        finally {
            storeLock.readLock().unlock();
        }
    }

    @POST
    @Path(value="commands")
    public String processCommand(String command) {
        if (command == null || command.isEmpty()) {
            throw new BadRequestException("No command specified.");
        }
        if ("disconnect".equals(command)) {
            broadcaster.closeAll();
            return "Disconnected.";
        }
        if (command.length() > "reconnect ".length() && command.startsWith("reconnect ")) {
            String when = command.substring("reconnect ".length());
            try {
                reconnectDelay = "now".equals(when) ? 0L : Long.parseLong(when);
                return "Reconnect strategy updated: " + when;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new BadRequestException("Command not recognized: '" + command + "'");
    }

    @GET
    @Path(value="events")
    @Produces(value={"text/event-stream"})
    public EventOutput itemEvents(@HeaderParam(value="Last-Event-ID") @DefaultValue(value="-1") int lastEventId) {
        EventOutput eventOutput = new EventOutput();
        if (lastEventId >= 0) {
            LOGGER.info("Received last event id :" + lastEventId);
            long delay = reconnectDelay;
            if (delay > 0L) {
                LOGGER.info("Non-zero reconnect delay [" + delay + "] - responding with HTTP 503.");
                throw new ServiceUnavailableException(Long.valueOf(delay));
            }
            LOGGER.info("Zero reconnect delay - reconnecting.");
            this.replayMissedEvents(lastEventId, eventOutput);
        }
        if (!broadcaster.add((ChunkedOutput)eventOutput)) {
            LOGGER.severe("!!! Unable to add new event output to the broadcaster !!!");
            throw new ServiceUnavailableException(Long.valueOf(5L));
        }
        return eventOutput;
    }

    private void replayMissedEvents(int lastEventId, EventOutput eventOutput) {
        try {
            storeLock.readLock().lock();
            int firstUnreceived = lastEventId + 1;
            int missingCount = itemStore.size() - firstUnreceived;
            if (missingCount > 0) {
                LOGGER.info("Replaying events - starting with id " + firstUnreceived);
                ListIterator it = itemStore.subList(firstUnreceived, itemStore.size()).listIterator();
                while (it.hasNext()) {
                    eventOutput.write((Object)this.createItemEvent(it.nextIndex() + firstUnreceived, (String)it.next()));
                }
            } else {
                LOGGER.info("No events to replay.");
            }
        }
        catch (IOException ex) {
            throw new InternalServerErrorException("Error replaying missed events", (Throwable)ex);
        }
        finally {
            storeLock.readLock().unlock();
        }
    }

    @POST
    public void addItem(@FormParam(value="name") String name) {
        if (name == null) {
            return;
        }
        try {
            storeLock.writeLock().lock();
            int eventId = itemStore.size();
            itemStore.add(name);
            broadcaster.broadcast((Object)this.createItemEvent(eventId, name));
            broadcaster.broadcast((Object)new OutboundEvent.Builder().name("size").data(Integer.class, (Object)(eventId + 1)).build());
        }
        finally {
            storeLock.writeLock().unlock();
        }
    }

    private OutboundEvent createItemEvent(int eventId, String name) {
        Logger.getLogger(ItemStoreResource.class.getName()).info("Creating event id [" + eventId + "] name [" + name + "]");
        return new OutboundEvent.Builder().id("" + eventId).data(String.class, (Object)name).build();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static {
        broadcaster.add((BroadcasterListener)new /* Unavailable Anonymous Inner Class!! */);
        reconnectDelay = 0L;
    }
}

