/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class MyX509TrustManager
implements X509TrustManager {
    private X509TrustManager pkixTrustManager;

    MyX509TrustManager(String trustStore, char[] password) throws Exception {
        this(new File(trustStore), password);
    }

    MyX509TrustManager(File trustStore, char[] password) throws Exception {
        TrustManager[] tms;
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(trustStore), password);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
        tmf.init(ks);
        for (TrustManager tm : tms = tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.pkixTrustManager = (X509TrustManager)tm;
            return;
        }
        throw new Exception("Couldn't initialize");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.pkixTrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.pkixTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.pkixTrustManager.getAcceptedIssuers();
    }
}

