/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.examples.aggregator.Message;
import org.glassfish.jersey.media.sse.EventChannel;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.ChunkedOutput;

@Path(value="message/stream")
public class MessageStreamResource {
    private static final Logger LOGGER = Logger.getLogger(MessageStreamResource.class.getName());
    private static SseBroadcaster broadcaster = new SseBroadcaster(){

        public void onException(ChunkedOutput<OutboundEvent> chunkedOutput, Exception exception) {
            LOGGER.log(Level.SEVERE, "Error broadcasting message.", exception);
        }
    };
    private static AtomicLong nextMessageId = new AtomicLong(0L);

    @PUT
    @Consumes(value={"application/json"})
    public void putMessage(Message message) {
        LOGGER.info("--> Message received.");
        OutboundEvent event = new OutboundEvent.Builder().id(String.valueOf(nextMessageId.getAndIncrement())).mediaType(MediaType.APPLICATION_JSON_TYPE).data(Message.class, (Object)message).build();
        broadcaster.broadcast((Object)event);
    }

    @GET
    @Produces(value={"text/event-stream"})
    public EventChannel getMessageStream() {
        LOGGER.info("--> SSE connection received.");
        EventChannel eventChannel = new EventChannel();
        broadcaster.add(eventChannel);
        return eventChannel;
    }
}

