/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import java.io.File;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

class MyX509KeyManager
implements X509KeyManager {
    private X509KeyManager pkixKeyManager;

    MyX509KeyManager(String keyStore, char[] password) throws Exception {
        this(new File(keyStore), password);
    }

    MyX509KeyManager(File keyStore, char[] password) throws Exception {
        KeyManager[] kms;
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(keyStore), password);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
        kmf.init(ks, "asdfgh".toCharArray());
        for (KeyManager km : kms = kmf.getKeyManagers()) {
            if (!(km instanceof X509KeyManager)) continue;
            this.pkixKeyManager = (X509KeyManager)km;
            return;
        }
        throw new Exception("Couldn't initialize");
    }

    @Override
    public PrivateKey getPrivateKey(String arg0) {
        return this.pkixKeyManager.getPrivateKey(arg0);
    }

    @Override
    public X509Certificate[] getCertificateChain(String arg0) {
        return this.pkixKeyManager.getCertificateChain(arg0);
    }

    @Override
    public String[] getClientAliases(String arg0, Principal[] arg1) {
        return this.pkixKeyManager.getClientAliases(arg0, arg1);
    }

    @Override
    public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
        return this.pkixKeyManager.chooseClientAlias(arg0, arg1, arg2);
    }

    @Override
    public String[] getServerAliases(String arg0, Principal[] arg1) {
        return this.pkixKeyManager.getServerAliases(arg0, arg1);
    }

    @Override
    public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
        return this.pkixKeyManager.chooseServerAlias(arg0, arg1, arg2);
    }
}

