/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import java.util.Random;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientFactory;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.examples.aggregator.App;
import org.glassfish.jersey.examples.aggregator.DataAggregator;
import org.glassfish.jersey.examples.aggregator.DataListener;
import org.glassfish.jersey.examples.aggregator.Message;
import org.glassfish.jersey.moxy.json.MoxyJsonFeature;

public class TestAggregator
implements DataAggregator {
    private static final Logger LOGGER = Logger.getLogger(TestAggregator.class.getName());
    private static final String[] MESSAGES = new String[]{"Where do your RESTful Web Services want to go today?", "Jersey RESTful Web Services framework rocks!", "Jersey and JAX-RS are cool!", "What are the 5 insane but true things about JAX-RS?", "Wow, JAX-RS 2.0 provides asynchronous service and client APIs!", "Finally! JAX-RS 2.0 adds filters and interceptors support.", "Jersey 2.0 programmatic resource API looks great!", "How could I live without Jersey ResourceConfig class??", "Just wrote my first JAX-RS service using Jersey.", "Jersey is the best RESTful framework ever.", "JAX-RS rules the web services.", "Jersey 2.0 is the new American idol!"};
    private final String rgbColor;
    private volatile boolean running;

    public TestAggregator(String rgbColor) {
        this.rgbColor = rgbColor;
    }

    @Override
    public void start(String keywords, final DataListener msgListener) {
        msgListener.onStart();
        this.running = true;
        final Random rnd = new Random();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Client resourceClient = ClientFactory.newClient();
                resourceClient.register((Object)new MoxyJsonFeature());
                WebTarget messageStreamResource = resourceClient.target(App.getApiUri()).path("message/stream");
                try {
                    while (TestAggregator.this.running) {
                        Message message = new Message(MESSAGES[rnd.nextInt(MESSAGES.length)], TestAggregator.this.rgbColor, "http://files.softicons.com/download/internet-cons/halloween-avatars-icons-by-deleket/png/48/Voodoo%20Doll.png");
                        msgListener.onMessage(message);
                        Response r = messageStreamResource.request().put(Entity.json((Object)message));
                        if (r.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                            LOGGER.warning("Unexpected PUT message response status code: " + r.getStatus());
                        }
                        Thread.sleep(rnd.nextInt(1000) + 750);
                    }
                    msgListener.onComplete();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Waiting for a message has been interrupted.", t);
                    msgListener.onError();
                }
            }
        });
    }

    @Override
    public void stop() {
        this.running = false;
    }
}

