/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.jersey.examples.aggregator.MainWindow;
import org.glassfish.jersey.examples.aggregator.MessageStreamResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.media.sse.SseFeature;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.glassfish.jersey.moxy.json.MoxyJsonFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class App {
    private static final Properties TWITTER_PROPERTIES = App.loadSettings();
    private static final String TWITTER_USER_NAME = "twitter.user.name";
    private static final String TWITTER_USER_PASSWORD = "twitter.user.password";
    private static final String TWITTER_PROPERTIES_FILE_NAME = "twitter-api.properties";
    public static final String APP_PATH = "/aggregator/";
    public static final String API_PATH = "/aggregator-api/";
    public static final String WEB_ROOT = "/webroot";
    public static final int PORT = 8080;

    public static HttpServer startServer(String webRootPath) {
        HttpServer server = new HttpServer();
        NetworkListener listener = new NetworkListener("grizzly", "localhost", 8080);
        server.addListener(listener);
        ServerConfiguration config = server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new StaticContentHandler(webRootPath), new String[]{APP_PATH});
        config.addHttpHandler((HttpHandler)RuntimeDelegate.getInstance().createEndpoint((Application)App.createResourceConfig(), GrizzlyHttpContainer.class), new String[]{API_PATH});
        try {
            server.start();
        }
        catch (Exception ex) {
            throw new ProcessingException("Exception thrown when trying to start grizzly server", (Throwable)ex);
        }
        return server;
    }

    public static void main(String[] args) {
        MainWindow.main(args);
        try {
            System.out.println("\"SSE Twitter Message Aggregator\" Jersey Example App");
            HttpServer server = App.startServer(args.length >= 1 ? args[0] : null);
            System.out.println(String.format("Application started.\nAccess it at %s\nHit enter to stop it...", App.getAppUri()));
            System.in.read();
            server.shutdownNow();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String getApiUri() {
        return String.format("http://localhost:%s%s", 8080, API_PATH);
    }

    public static String getAppUri() {
        return String.format("http://localhost:%s%s", 8080, APP_PATH);
    }

    public static ResourceConfig createResourceConfig() {
        return new ResourceConfig().registerClasses(new Class[]{MessageStreamResource.class, SseFeature.class, MoxyJsonFeature.class});
    }

    public static String getTwitterUserName() {
        return (String)TWITTER_PROPERTIES.get(TWITTER_USER_NAME);
    }

    public static String getTwitterUserPassword() {
        return (String)TWITTER_PROPERTIES.get(TWITTER_USER_PASSWORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadSettings() {
        Properties properties = new Properties();
        FileInputStream st = null;
        try {
            String homeDir = System.getProperty("user.home");
            st = new FileInputStream(homeDir + File.separator + TWITTER_PROPERTIES_FILE_NAME);
            properties.load(st);
        }
        catch (IOException e) {
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (IOException ex) {}
            }
        }
        for (String name : new String[]{TWITTER_USER_NAME, TWITTER_USER_PASSWORD}) {
            String value = System.getProperty(name);
            if (value == null) continue;
            properties.setProperty(name, value);
        }
        if (properties.getProperty(TWITTER_USER_NAME) == null || properties.getProperty(TWITTER_USER_PASSWORD) == null) {
            System.out.println(String.format("'%s' and '%s' properties not set. You need to provide them either via '$HOME/%s' file or as system properties.", TWITTER_USER_NAME, TWITTER_USER_PASSWORD, TWITTER_PROPERTIES_FILE_NAME));
            System.exit(1);
        }
        return properties;
    }

    private static class StaticContentHandler
    extends HttpHandler {
        private static final HashMap<String, String> EXTENSION_TO_MEDIA_TYPE = new HashMap();
        private final String webRootPath;

        StaticContentHandler(String webRootPath) {
            this.webRootPath = webRootPath;
        }

        public void service(Request request, Response response) throws Exception {
            InputStream fileStream;
            String uri = request.getRequestURI();
            int pos = uri.lastIndexOf(46);
            String extension = uri.substring(pos + 1);
            String mediaType = EXTENSION_TO_MEDIA_TYPE.get(extension);
            if (uri.contains("..") || mediaType == null) {
                response.sendError(HttpStatus.NOT_FOUND_404.getStatusCode());
                return;
            }
            String resourcesContextPath = request.getContextPath();
            if (resourcesContextPath != null && !resourcesContextPath.isEmpty()) {
                if (!uri.startsWith(resourcesContextPath)) {
                    response.sendError(HttpStatus.NOT_FOUND_404.getStatusCode());
                    return;
                }
                uri = uri.substring(resourcesContextPath.length());
            }
            try {
                fileStream = this.webRootPath == null ? App.class.getResourceAsStream(App.WEB_ROOT + uri) : new FileInputStream(this.webRootPath + uri);
            }
            catch (IOException e) {
                fileStream = null;
            }
            if (fileStream == null) {
                response.sendError(HttpStatus.NOT_FOUND_404.getStatusCode());
            } else {
                response.setStatus(HttpStatus.OK_200);
                response.setContentType(mediaType);
                ReaderWriter.writeTo((InputStream)fileStream, (OutputStream)response.getOutputStream());
            }
        }

        static {
            EXTENSION_TO_MEDIA_TYPE.put("html", "text/html");
            EXTENSION_TO_MEDIA_TYPE.put("js", "application/javascript");
            EXTENSION_TO_MEDIA_TYPE.put("css", "text/css");
            EXTENSION_TO_MEDIA_TYPE.put("png", "image/png");
            EXTENSION_TO_MEDIA_TYPE.put("ico", "image/png");
        }
    }
}

