/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.glassfish.jersey.examples.aggregator.DataAggregator;
import org.glassfish.jersey.examples.aggregator.DataListener;
import org.glassfish.jersey.examples.aggregator.Message;
import org.glassfish.jersey.examples.aggregator.RemoveSelectedListItemsAction;
import org.glassfish.jersey.examples.aggregator.TestAggregator;
import org.glassfish.jersey.examples.aggregator.TwitterAggregator;
import org.jdesktop.layout.GroupLayout;

public class MainWindow
extends JFrame {
    private final DefaultListModel keywordListModel = new DefaultListModel();
    private final AtomicBoolean receiveMessages = new AtomicBoolean(false);
    private final List<DataAggregator> dataAggregators;
    private JButton addButton;
    private JLabel connectionStatusLabel;
    private JPanel jPanel4;
    private JList keywordList;
    private JTextArea messagesArea;
    private JTextField newKeywordField;
    private JButton startStopButton;
    private JCheckBox testCheckbox;
    private JLabel testColorLabel;
    private JCheckBox twitterCheckbox;
    private JLabel twitterColorLabel;

    public MainWindow() {
        this.initComponents();
        ActionMap actionMap = this.keywordList.getActionMap();
        InputMap inputMap = this.keywordList.getInputMap(0);
        String actionKey = "RemoveSelectedListItems";
        actionMap.put("RemoveSelectedListItems", new RemoveSelectedListItemsAction(this.keywordList, this.keywordListModel));
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "RemoveSelectedListItems");
        this.dataAggregators = new ArrayList<DataAggregator>(2);
    }

    private void initAggregators() {
        if (this.twitterCheckbox.isSelected()) {
            this.dataAggregators.add(new TwitterAggregator(this.colorToString(this.twitterColorLabel.getBackground())));
        }
        if (this.testCheckbox.isSelected()) {
            this.dataAggregators.add(new TestAggregator(this.colorToString(this.testColorLabel.getBackground())));
        }
    }

    private String colorToString(Color color) {
        StringBuilder colorBuilder = new StringBuilder();
        colorBuilder.append(String.format("%02X", color.getRed())).append(String.format("%02X", color.getGreen())).append(String.format("%02X", color.getBlue()));
        return colorBuilder.toString();
    }

    private void onKeywordEntered(ActionEvent evt) {
        String keyword = this.newKeywordField.getText();
        if (keyword == null || keyword.isEmpty() || this.keywordListModel.contains(keyword)) {
            return;
        }
        this.addButton.doClick();
    }

    private void onAdd(ActionEvent evt) {
        String keyword = this.newKeywordField.getText();
        if (keyword == null || keyword.isEmpty() || this.keywordListModel.contains(keyword)) {
            return;
        }
        this.keywordListModel.addElement(keyword);
        this.newKeywordField.setText("");
    }

    private void onStartOrStop(ActionEvent evt) {
        if (this.receiveMessages.get()) {
            this.receiveMessages.set(false);
            this.startStopButton.setText("Start");
            this.newKeywordField.setEnabled(true);
            this.addButton.setEnabled(true);
            this.stop();
        } else {
            this.receiveMessages.set(true);
            this.startStopButton.setText("Stop");
            this.connectionStatusLabel.setText("Connecting...");
            this.newKeywordField.setEnabled(false);
            this.addButton.setEnabled(false);
            this.messagesArea.setText("");
            StringBuilder keywordsBuilder = new StringBuilder();
            Enumeration elements = this.keywordListModel.elements();
            while (elements.hasMoreElements()) {
                keywordsBuilder.append(elements.nextElement());
                if (!elements.hasMoreElements()) continue;
                keywordsBuilder.append(",");
            }
            this.start(keywordsBuilder.toString(), new DataListener(){

                @Override
                public void onStart() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainWindow.this.connectionStatusLabel.setText("Connected.");
                        }
                    });
                }

                @Override
                public void onMessage(final Message message) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainWindow.this.messagesArea.append(message.getText() + "\n\n");
                        }
                    });
                }

                @Override
                public void onError() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainWindow.this.connectionStatusLabel.setText("Connection Error!");
                            MainWindow.this.receiveMessages.set(false);
                            MainWindow.this.startStopButton.setText("Start");
                            MainWindow.this.newKeywordField.setEnabled(true);
                            MainWindow.this.addButton.setEnabled(true);
                        }
                    });
                }

                @Override
                public void onComplete() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainWindow.this.connectionStatusLabel.setText("Disconnected.");
                        }
                    });
                }
            });
        }
    }

    private void stop() {
        for (DataAggregator dataAggregator : this.dataAggregators) {
            dataAggregator.stop();
        }
        this.dataAggregators.clear();
    }

    private void start(String keywords, DataListener listener) {
        this.initAggregators();
        for (DataAggregator dataAggregator : this.dataAggregators) {
            dataAggregator.start(keywords, listener);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow messageAggregator = new MainWindow();
                messageAggregator.setLocationRelativeTo(null);
                messageAggregator.setVisible(true);
            }
        });
    }

    private void initComponents() {
        JPanel jPanel3 = new JPanel();
        this.newKeywordField = new JTextField();
        this.addButton = new JButton();
        JPanel jPanel1 = new JPanel();
        this.connectionStatusLabel = new JLabel();
        this.startStopButton = new JButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.messagesArea = new JTextArea();
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.keywordList = new JList();
        this.jPanel4 = new JPanel();
        this.twitterCheckbox = new JCheckBox();
        this.twitterColorLabel = new JLabel();
        this.testColorLabel = new JLabel();
        this.testCheckbox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Message aggregator");
        this.setMinimumSize(new Dimension(304, 300));
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.newKeywordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onKeywordEntered(evt);
            }
        });
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onAdd(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)jPanel3);
        jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.newKeywordField).addPreferredGap(0).add((Component)this.addButton, -2, 72, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.newKeywordField, -2, -1, -2).add((Component)this.addButton)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.startStopButton.setText("Start");
        this.startStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onStartOrStop(evt);
            }
        });
        this.messagesArea.setColumns(20);
        this.messagesArea.setLineWrap(true);
        this.messagesArea.setRows(5);
        this.messagesArea.setWrapStyleWord(true);
        this.messagesArea.setFocusable(false);
        jScrollPane2.setViewportView(this.messagesArea);
        GroupLayout jPanel1Layout = new GroupLayout((Container)jPanel1);
        jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)jScrollPane2, -1, 247, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.connectionStatusLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.startStopButton)))));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.startStopButton).add((Component)this.connectionStatusLabel)).addPreferredGap(0).add((Component)jScrollPane2).addContainerGap()));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.keywordList.setModel(this.keywordListModel);
        jScrollPane1.setViewportView(this.keywordList);
        GroupLayout jPanel2Layout = new GroupLayout((Container)jPanel2);
        jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)jScrollPane1, -1, 97, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)jScrollPane1, -1, 332, Short.MAX_VALUE).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.twitterCheckbox.setSelected(true);
        this.twitterCheckbox.setText("Twitter aggregator");
        this.twitterColorLabel.setBackground(new Color(85, 170, 0));
        this.twitterColorLabel.setText("    ");
        this.twitterColorLabel.setOpaque(true);
        this.testColorLabel.setBackground(new Color(0, 85, 170));
        this.testColorLabel.setText("    ");
        this.testColorLabel.setOpaque(true);
        this.testCheckbox.setText("Test Aggregator");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.twitterColorLabel).addPreferredGap(0).add((Component)this.twitterCheckbox, -1, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.testColorLabel).addPreferredGap(0).add((Component)this.testCheckbox, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.twitterCheckbox).add((Component)this.twitterColorLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.testCheckbox).add((Component)this.testColorLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((Component)jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }
}

