/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.aggregator;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.glassfish.jersey.examples.aggregator.Message;

@Path(value="message/stream/jaxrs")
@Singleton
public final class MessageStreamResourceJaxRs {
    private static final Logger LOGGER = Logger.getLogger(MessageStreamResourceJaxRs.class.getName());
    private static AtomicLong nextMessageId = new AtomicLong(0L);
    private final Sse sse;
    private final SseBroadcaster broadcaster;

    public MessageStreamResourceJaxRs(@Context Sse sse) {
        this.sse = sse;
        this.broadcaster = sse.newBroadcaster();
    }

    @PUT
    @Consumes(value={"application/json"})
    public void putMessage(Message message) {
        LOGGER.info("--> Message received.");
        OutboundSseEvent event = this.sse.newEventBuilder().id(String.valueOf(nextMessageId.getAndIncrement())).mediaType(MediaType.APPLICATION_JSON_TYPE).data(Message.class, (Object)message).build();
        this.broadcaster.broadcast(event);
    }

    @GET
    @Produces(value={"text/event-stream"})
    public void getMessageStream(@Context SseEventSink eventSink) {
        LOGGER.info("--> SSE connection received.");
        this.broadcaster.register(eventSink);
    }
}

