/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.transaction.internal;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Qualifier;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.BindingBuilder;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;
import org.glassfish.jersey.ext.cdi1x.internal.CdiBeanHk2Factory;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.ext.cdi1x.transaction.internal.TransactionalExceptionMapper;
import org.glassfish.jersey.ext.cdi1x.transaction.internal.WebAppExceptionHolder;
import org.glassfish.jersey.ext.cdi1x.transaction.internal.WebAppExceptionInterceptor;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.server.spi.ComponentProvider;

@Priority(value=199)
public class TransactionalExceptionInterceptorProvider
implements ComponentProvider,
Extension {
    private ServiceLocator locator;
    private BeanManager beanManager;

    public void initialize(ServiceLocator locator) {
        this.locator = locator;
        this.beanManager = CdiUtil.lookupBeanManager();
    }

    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        return false;
    }

    public void done() {
        if (this.beanManager != null) {
            this.bindWaeRestoringExceptionMapper();
        }
    }

    private void bindWaeRestoringExceptionMapper() {
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        ServiceBindingBuilder bindingBuilder = Injections.newFactoryBinder((Factory)new CdiBeanHk2Factory(TransactionalExceptionMapper.class, this.locator, this.beanManager, true));
        bindingBuilder.to(ExceptionMapper.class);
        Injections.addBinding((BindingBuilder)bindingBuilder, (DynamicConfiguration)dc);
        dc.commit();
    }

    private void afterTypeDiscovery(@Observes AfterTypeDiscovery afterTypeDiscovery) {
        List interceptors = afterTypeDiscovery.getInterceptors();
        interceptors.add(WebAppExceptionInterceptor.class);
    }

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(WebAppExceptionHolder.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(WebAppExceptionInterceptor.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TransactionalExceptionMapper.class));
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
    public static @interface WaeQualifier {
    }
}

