/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.transaction.internal;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.transaction.TransactionalException;
import org.glassfish.jersey.ext.cdi1x.internal.JerseyVetoed;
import org.glassfish.jersey.ext.cdi1x.transaction.internal.TransactionalExceptionInterceptorProvider;
import org.glassfish.jersey.ext.cdi1x.transaction.internal.WebAppExceptionHolder;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;

@ApplicationScoped
@JerseyVetoed
public class TransactionalExceptionMapper
implements ExtendedExceptionMapper<TransactionalException> {
    @Inject
    @TransactionalExceptionInterceptorProvider.WaeQualifier
    private WebAppExceptionHolder waeHolder;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Provider<ExceptionMappers> mappers;

    public Response toResponse(TransactionalException exception) {
        WebApplicationException wae;
        ExceptionMapper mapper = ((ExceptionMappers)this.mappers.get()).findMapping((Throwable)exception);
        if (mapper != null && !TransactionalExceptionMapper.class.isAssignableFrom(mapper.getClass())) {
            return mapper.toResponse((Throwable)exception);
        }
        if (this.waeHolder != null && (wae = this.waeHolder.getException()) != null) {
            return wae.getResponse();
        }
        throw exception;
    }

    public boolean isMappable(TransactionalException exception) {
        return true;
    }
}

