/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.validation.internal;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.glassfish.jersey.ext.cdi1x.validation.internal.CdiInterceptorWrapperExtension;
import org.hibernate.validator.cdi.internal.interceptor.MethodValidated;
import org.hibernate.validator.cdi.internal.interceptor.ValidationInterceptor;

@MethodValidated
@Interceptor
@Priority(value=4800)
public class CdiInterceptorWrapper {
    private final ValidationInterceptor interceptor;
    @Inject
    private CdiInterceptorWrapperExtension extension;

    @Inject
    public CdiInterceptorWrapper(BeanManager beanManager) {
        Set interceptorBeans = beanManager.getBeans(ValidationInterceptor.class, new Annotation[0]);
        Bean interceptorBean = beanManager.resolve(interceptorBeans);
        this.interceptor = (ValidationInterceptor)beanManager.getReference(interceptorBean, ValidationInterceptor.class, beanManager.createCreationalContext((Contextual)interceptorBean));
    }

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        boolean isJaxRsMethod = (Boolean)this.extension.jaxRsResourceCache.apply(ctx.getMethod().getDeclaringClass());
        return isJaxRsMethod ? ctx.proceed() : this.interceptor.validateMethodInvocation(ctx);
    }

    @AroundConstruct
    public void validateConstructorInvocation(InvocationContext ctx) throws Exception {
        boolean isJaxRsConstructor = (Boolean)this.extension.jaxRsResourceCache.apply(ctx.getConstructor().getDeclaringClass());
        if (!isJaxRsConstructor) {
            this.interceptor.validateConstructorInvocation(ctx);
        }
    }
}

