/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.validation.internal;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.jersey.ext.cdi1x.internal.JerseyVetoed;
import org.glassfish.jersey.ext.cdi1x.validation.internal.CdiInterceptorWrapper;
import org.glassfish.jersey.internal.util.collection.Cache;
import org.glassfish.jersey.server.model.Resource;
import org.hibernate.validator.cdi.internal.interceptor.ValidationInterceptor;

@Priority(value=199)
@JerseyVetoed
public class CdiInterceptorWrapperExtension
implements Extension {
    public static final AnnotationLiteral<Default> DEFAULT_ANNOTATION_LITERAL = new AnnotationLiteral<Default>(){};
    public static final AnnotationLiteral<Any> ANY_ANNOTATION_LITERAL = new AnnotationLiteral<Any>(){};
    private Cache<Class<?>, Boolean> jaxRsResourceCache = new Cache(clazz -> Resource.from((Class)clazz) != null);
    private AnnotatedType<ValidationInterceptor> interceptorAnnotatedType;

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager beanManager) {
        beforeBeanDiscoveryEvent.addAnnotatedType(beanManager.createAnnotatedType(CdiInterceptorWrapper.class), "Jersey " + CdiInterceptorWrapper.class.getName());
        this.interceptorAnnotatedType = beanManager.createAnnotatedType(ValidationInterceptor.class);
        beforeBeanDiscoveryEvent.addAnnotatedType(this.interceptorAnnotatedType, "Jersey " + ValidationInterceptor.class.getName());
    }

    private void afterTypeDiscovery(@Observes AfterTypeDiscovery afterTypeDiscovery) {
        afterTypeDiscovery.getInterceptors().remove(ValidationInterceptor.class);
    }

    private void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        AnnotatedType<ValidationInterceptor> interceptorType = this.interceptorAnnotatedType;
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(interceptorType);
        final InjectionTarget interceptorTarget = injectionTargetFactory.createInjectionTarget(null);
        afterBeanDiscovery.addBean((Bean)new Bean<ValidationInterceptor>(){

            public Class<?> getBeanClass() {
                return ValidationInterceptor.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return interceptorTarget.getInjectionPoints();
            }

            public String getName() {
                return "HibernateValidationInterceptorImpl";
            }

            public Set<Annotation> getQualifiers() {
                return new HashSet<Annotation>(){
                    {
                        this.add(DEFAULT_ANNOTATION_LITERAL);
                        this.add(ANY_ANNOTATION_LITERAL);
                    }
                };
            }

            public Class<? extends Annotation> getScope() {
                return Dependent.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                return new HashSet<Type>(){
                    {
                        this.add(ValidationInterceptor.class);
                        this.add(Object.class);
                    }
                };
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public ValidationInterceptor create(CreationalContext<ValidationInterceptor> ctx) {
                ValidationInterceptor result = (ValidationInterceptor)interceptorTarget.produce(ctx);
                interceptorTarget.inject((Object)result, ctx);
                interceptorTarget.postConstruct((Object)result);
                return result;
            }

            public void destroy(ValidationInterceptor instance, CreationalContext<ValidationInterceptor> ctx) {
                interceptorTarget.preDestroy((Object)instance);
                interceptorTarget.dispose((Object)instance);
                ctx.release();
            }
        });
    }

    Cache<Class<?>, Boolean> getJaxRsResourceCache() {
        return this.jaxRsResourceCache;
    }
}

