
package org.glassfish.jersey.ext.cdi1x.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.ext.cdi1x.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableCDI_TYPE_VETOED(Object arg0, Object arg1) {
        return messageFactory.getMessage("cdi.type.vetoed", arg0, arg1);
    }

    /**
     * The following types have been vetoed by Jersey as per {0} configuration: {1}
     * 
     */
    public static String CDI_TYPE_VETOED(Object arg0, Object arg1) {
        return localizer.localize(localizableCDI_TYPE_VETOED(arg0, arg1));
    }

    public static Localizable localizableCDI_CLASS_ANALYZER_MISUSED() {
        return messageFactory.getMessage("cdi.class.analyzer.misused");
    }

    /**
     * Jersey CDI class analyzer is supposed to be used only for field and method inspection when injecting CDI beans.
     * 
     */
    public static String CDI_CLASS_ANALYZER_MISUSED() {
        return localizer.localize(localizableCDI_CLASS_ANALYZER_MISUSED());
    }

    public static Localizable localizableCDI_HK_2_BEAN_REGISTERED(Object arg0) {
        return messageFactory.getMessage("cdi.hk2.bean.registered", arg0);
    }

    /**
     * CDI beans backed by HK2 have been registered for the following types: {0}
     * 
     */
    public static String CDI_HK_2_BEAN_REGISTERED(Object arg0) {
        return localizer.localize(localizableCDI_HK_2_BEAN_REGISTERED(arg0));
    }

    public static Localizable localizableCDI_CLASS_BEING_CHECKED(Object arg0) {
        return messageFactory.getMessage("cdi.class.being.checked", arg0);
    }

    /**
     * Class, {0}, is being checked with Jersey CDI component provider.
     * 
     */
    public static String CDI_CLASS_BEING_CHECKED(Object arg0) {
        return localizer.localize(localizableCDI_CLASS_BEING_CHECKED(arg0));
    }

    public static Localizable localizableCDI_CLASS_BOUND_WITH_CDI(Object arg0) {
        return messageFactory.getMessage("cdi.class.bound.with.cdi", arg0);
    }

    /**
     * Class, {0}, has been bound by Jersey CDI component provider.
     * 
     */
    public static String CDI_CLASS_BOUND_WITH_CDI(Object arg0) {
        return localizer.localize(localizableCDI_CLASS_BOUND_WITH_CDI(arg0));
    }

    public static Localizable localizableCDI_LOOKUP_FAILED(Object arg0) {
        return messageFactory.getMessage("cdi.lookup.failed", arg0);
    }

    /**
     * Error when lookup instance of class, {0}, in CDI.
     * 
     */
    public static String CDI_LOOKUP_FAILED(Object arg0) {
        return localizer.localize(localizableCDI_LOOKUP_FAILED(arg0));
    }

    public static Localizable localizableCDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED() {
        return messageFactory.getMessage("cdi.bean.manager.jndi.lookup.failed");
    }

    /**
     * Failed to obtain BeanManager from JNDI lookup.
     * 
     */
    public static String CDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED() {
        return localizer.localize(localizableCDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED());
    }

    public static Localizable localizableCDI_PROVIDER_INITIALIZED() {
        return messageFactory.getMessage("cdi.provider.initialized");
    }

    /**
     * Jersey CDI component provider initialized.
     * 
     */
    public static String CDI_PROVIDER_INITIALIZED() {
        return localizer.localize(localizableCDI_PROVIDER_INITIALIZED());
    }

}
