/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.ext.cdi1x.internal.LocalizationMessages;

public final class CdiBeanHk2Factory<T>
implements Factory<T> {
    final Class<T> clazz;
    final InstanceManager<T> referenceProvider;
    final Annotation[] qualifiers;

    public T provide() {
        T instance = this.referenceProvider.getInstance(this.clazz);
        if (instance != null) {
            return instance;
        }
        throw new NoSuchElementException(LocalizationMessages.CDI_LOOKUP_FAILED(this.clazz));
    }

    public void dispose(T instance) {
        this.referenceProvider.preDestroy(instance);
    }

    public CdiBeanHk2Factory(Class<T> rawType, final ServiceLocator locator, final BeanManager beanManager, boolean cdiManaged) {
        this.clazz = rawType;
        this.qualifiers = CdiUtil.getQualifiers(this.clazz.getAnnotations());
        this.referenceProvider = cdiManaged ? new InstanceManager<T>(){
            final Iterator<Bean<?>> beans;
            final Bean bean;
            final CreationalContext creationalContext;
            {
                this.beans = beanManager.getBeans(CdiBeanHk2Factory.this.clazz, CdiBeanHk2Factory.this.qualifiers).iterator();
                this.bean = this.beans.hasNext() ? this.beans.next() : null;
                this.creationalContext = this.bean != null ? beanManager.createCreationalContext((Contextual)this.bean) : null;
            }

            @Override
            public T getInstance(Class<T> clazz) {
                return this.bean != null ? beanManager.getReference(this.bean, clazz, this.creationalContext) : null;
            }

            @Override
            public void preDestroy(T instance) {
            }
        } : new InstanceManager<T>(){
            final AnnotatedType<T> annotatedType;
            final InjectionTargetFactory<T> injectionTargetFactory;
            final InjectionTarget<T> injectionTarget;
            final CreationalContext<T> creationalContext;
            {
                this.annotatedType = beanManager.createAnnotatedType(CdiBeanHk2Factory.this.clazz);
                this.injectionTargetFactory = beanManager.getInjectionTargetFactory(this.annotatedType);
                this.injectionTarget = this.injectionTargetFactory.createInjectionTarget(null);
                this.creationalContext = beanManager.createCreationalContext(null);
            }

            @Override
            public T getInstance(Class<T> clazz) {
                Object instance = this.injectionTarget.produce(this.creationalContext);
                this.injectionTarget.inject(instance, this.creationalContext);
                if (locator != null) {
                    locator.inject(instance, "CdiInjecteeSkippingClassAnalyzer");
                }
                this.injectionTarget.postConstruct(instance);
                return instance;
            }

            @Override
            public void preDestroy(T instance) {
                this.injectionTarget.preDestroy(instance);
            }
        };
    }

    private static interface InstanceManager<T> {
        public T getInstance(Class<T> var1);

        public void preDestroy(T var1);
    }
}

