/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Qualifier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.jersey.ext.cdi1x.internal.LocalizationMessages;

public final class CdiUtil {
    private static final Logger LOGGER = Logger.getLogger(CdiUtil.class.getName());

    private CdiUtil() {
    }

    public static Annotation[] getQualifiers(Annotation[] annotations) {
        ArrayList<Annotation> result = new ArrayList<Annotation>(annotations.length);
        for (Annotation a : annotations) {
            if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            result.add(a);
        }
        return result.toArray(new Annotation[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanManager lookupBeanManager() {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            BeanManager beanManager = (BeanManager)initialContext.lookup("java:comp/BeanManager");
            return beanManager;
        }
        catch (Exception ex) {
            try {
                BeanManager ignored = CDI.current().getBeanManager();
                return ignored;
            }
            catch (Exception e) {
                LOGGER.config(LocalizationMessages.CDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED());
                BeanManager beanManager = null;
                return beanManager;
            }
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }
}

